package org.simantics.db;

import java.util.TreeMap;

import org.simantics.db.exception.ServiceException;

public interface MetadataI {
    /**
     * Sets given meta data to be used with next commit.
     * 
     * @param metadata
     * @throws ServiceException
     */
    <T> void addMetadata(Metadata metadata) throws ServiceException;

    /**
     * Returns asked class from the meta data of next commit.
     * 
     * @param clazz asked class
     * @return instance of asked class
     * @throws ServiceException
     */
    <T extends Metadata> T getMetadata(Class<T> clazz) throws ServiceException;
    /**
     * Returns meta data serialized for next commit.
     * 
     * @return meta data
     */
    TreeMap<String, byte[]> getMetadata();
}
