/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.db.internal.Activator;

/**
 * @author Antti Villberg
 */
public final class Manager {

    private Manager() {}

    /**
     * Search for registered database driver by driver id.
     *
     * @param id for database driver.
     * @return database driver or null.
     */
    public static Driver getDriver(String id) {
        Map<String, Driver> drivers = collectDrivers();
        return drivers.get(id);
    }

    private static Map<String, Driver> collectDrivers() {
        BundleContext context = Activator.getContext();
        Collection<ServiceReference<Driver>> serviceReferences;
        try {
            serviceReferences = context.getServiceReferences(Driver.class, null);
        } catch (InvalidSyntaxException e) {
            e.printStackTrace();
            serviceReferences = Collections.emptyList();
        }
        Map<String, Driver> drivers = new HashMap<>(serviceReferences.size());
        for (ServiceReference<Driver> reference : serviceReferences) {
            Driver driver = context.getService(reference);
            String driverName = driver.getName();
            if (driverName != null && !driverName.isEmpty()) {
                drivers.put(driverName, driver);
            }
        }
        return drivers;
    }
    
    public static DatabaseUserAgent getUserAgent(String id) {
        Map<String, DatabaseUserAgent> agents = collectUserAgents();
        return agents.get(id);
    }
    
    private static Map<String, DatabaseUserAgent> collectUserAgents() {
        BundleContext context = Activator.getContext();
        Collection<ServiceReference<DatabaseUserAgent>> serviceReferences;
        try {
            serviceReferences = context.getServiceReferences(DatabaseUserAgent.class, null);
        } catch (InvalidSyntaxException e) {
            e.printStackTrace();
            serviceReferences = Collections.emptyList();
        }
        Map<String, DatabaseUserAgent> drivers = new HashMap<>(serviceReferences.size());
        for (ServiceReference<DatabaseUserAgent> reference : serviceReferences) {
            DatabaseUserAgent dbua = context.getService(reference);
            String driverName = dbua.getId();
            if (driverName != null && !driverName.isEmpty()) {
                drivers.put(driverName, dbua);
            }
        }
        return drivers;
    }

}
