/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.procore.cluster.Allocator;

class LongAllocator
extends Allocator {
    private long[] backup;
    private long[] memory;
    static final int ClusterId = 0;
    static final int HeaderSize = 1;

    LongAllocator releaseMemory() {
        this.backup = null;
        this.memory = null;
        return null;
    }

    long[] getBackup() {
        return this.backup;
    }

    long[] getMemory() {
        return this.memory;
    }

    long getClusterId() {
        return this.memory[0];
    }

    void setClusterId(long a) {
        this.memory[0] = a;
    }

    LongAllocator(long[] longs, int size) {
        assert (longs != null);
        assert (longs.length >= size);
        assert (longs.length >= 1);
        this.backup = null;
        this.memory = longs;
        this.setSize(size);
    }

    @Override
    int getCapacity() {
        return this.memory.length;
    }

    @Override
    void resizeMemory(int capacity) {
        assert (capacity >= 1);
        assert (this.backup == null);
        long[] t = null;
        try {
            t = new long[capacity];
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            throw e;
        }
        int copySize = Math.min(capacity, this.getSize());
        System.arraycopy(this.memory, 0, t, 0, copySize);
        this.setSize(copySize);
        this.memory = t;
    }

    @Override
    void backupResize(int capacity, int size, int copySize) {
        assert (capacity >= 1);
        assert (capacity >= copySize);
        assert (capacity >= size);
        if (size < 0) {
            size = this.getSize();
        } else if (size < 1) {
            size = 1;
        }
        assert (size <= capacity);
        if (copySize < 0) {
            copySize = size;
        }
        assert (copySize <= size);
        assert (copySize <= this.getSize());
        assert (this.backup == null);
        this.backup = this.memory;
        this.memory = new long[capacity];
        this.setSize(size);
        System.arraycopy(this.backup, 0, this.memory, 0, copySize);
    }

    @Override
    void backupFree() {
        this.backup = null;
    }

    void dump() {
        int i = 0;
        while (i < this.getSize()) {
            System.out.println("longs[" + i + "]=" + this.memory[i]);
            ++i;
        }
        System.out.println("longs capacity=" + this.memory.length);
    }
}

