/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.map.hash.TIntShortHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.InputStream;
import java.util.function.Consumer;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ExternalValueException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterMapSmall;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ClusterTraitsSmall;
import org.simantics.db.procore.cluster.CompleteTableSmall;
import org.simantics.db.procore.cluster.ForeignTableSmall;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.OutOfSpaceException;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ResourceTableSmall;
import org.simantics.db.procore.cluster.TableIntArraySet2;
import org.simantics.db.procore.cluster.TableIntSet2;
import org.simantics.db.procore.cluster.ValueTableSmall;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;
import org.simantics.db.service.ValueStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterSmall
extends ClusterImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSmall.class);
    private static final int TABLE_HEADER_SIZE = 8;
    private static final int RESOURCE_TABLE_OFFSET = 0;
    private static final int PREDICATE_TABLE_OFFSET = 8;
    private static final int OBJECT_TABLE_OFFSET = 16;
    private static final int VALUE_TABLE_OFFSET = 24;
    private static final int FLAT_TABLE_OFFSET = 32;
    private static final int COMPLETE_TABLE_OFFSET = 40;
    private static final int FOREIGN_TABLE_OFFSET = 48;
    private static final int INT_HEADER_SIZE = 56;
    private final int clusterBits;
    public final ResourceTableSmall resourceTable;
    private PredicateTable predicateTable;
    final ObjectTable objectTable;
    public final ValueTableSmall valueTable;
    public final ForeignTableSmall foreignTable;
    private final CompleteTableSmall completeTable;
    private final ClusterMapSmall clusterMap;
    private final int[] headerTable;
    private final ClusterSupport clusterSupport;
    private boolean proxy;
    private boolean deleted = false;
    static long fTime = 0L;
    int executeIndex = 0;
    long clusterUID1 = 0L;
    long clusterUID2 = 0L;

    public ClusterSmall(ClusterUID clusterUID, int clusterKey, ClusterTable clusterTable, ClusterSupport support) {
        super(clusterUID, clusterKey, support);
        this.proxy = true;
        this.headerTable = null;
        this.resourceTable = null;
        this.foreignTable = null;
        this.predicateTable = null;
        this.objectTable = null;
        this.valueTable = null;
        this.completeTable = null;
        this.clusterMap = null;
        this.clusterSupport = null;
        this.clusterBits = 0;
        this.importance = 0L;
    }

    public ClusterSmall(ClusterUID clusterUID, int clusterKey, ClusterSupport support) {
        super(clusterUID, clusterKey, support);
        this.proxy = false;
        this.headerTable = new int[56];
        this.resourceTable = new ResourceTableSmall((TableSizeListener)this, this.headerTable, 0);
        this.foreignTable = new ForeignTableSmall(this, this.headerTable, 48);
        this.predicateTable = new PredicateTable((TableSizeListener)this, this.headerTable, 8);
        this.objectTable = new ObjectTable((TableSizeListener)this, this.headerTable, 16);
        this.valueTable = new ValueTableSmall((TableSizeListener)this, this.headerTable, 24);
        this.completeTable = new CompleteTableSmall((TableSizeListener)this, this.headerTable, 40);
        this.clusterMap = new ClusterMapSmall((TableSizeListener)this, this.foreignTable);
        this.clusterSupport = support;
        this.clusterBits = ClusterTraitsBase.getClusterBits((int)clusterKey);
        this.importance = -this.clusterTable.timeCounter();
    }

    protected ClusterSmall(long[] longs, int[] ints, byte[] bytes, ClusterSupport support, int clusterKey) throws DatabaseException {
        super(ClusterSmall.checkValidity(-1L, longs, ints, bytes), clusterKey, support);
        this.proxy = false;
        if (ints.length < 56) {
            throw new IllegalArgumentException("Too small integer table for cluster.");
        }
        this.headerTable = ints;
        this.resourceTable = new ResourceTableSmall((TableSizeListener)this, ints, 0, longs);
        this.foreignTable = new ForeignTableSmall(this, this.headerTable, 48, longs);
        this.predicateTable = new PredicateTable((TableSizeListener)this, ints, 8, ints);
        this.objectTable = new ObjectTable((TableSizeListener)this, ints, 16, ints);
        this.valueTable = new ValueTableSmall((TableSizeListener)this, ints, 24, bytes);
        this.completeTable = new CompleteTableSmall((TableSizeListener)this, this.headerTable, 40, ints);
        this.clusterMap = new ClusterMapSmall((TableSizeListener)this, this.foreignTable);
        this.clusterSupport = support;
        this.clusterBits = ClusterTraitsBase.getClusterBits((int)clusterKey);
        this.importance = this.clusterTable.timeCounter();
        this.clusterTable.markImmutable((ClusterI)this, this.getImmutable());
    }

    void analyse() {
        System.out.println("Cluster " + this.clusterId);
        System.out.println("-size:" + this.getUsedSpace());
        System.out.println(" -rt:" + (this.resourceTable.getTableCapacity() * 8 + 8));
        System.out.println(" -ft:" + this.foreignTable.getTableCapacity() * 8);
        System.out.println(" -pt:" + this.predicateTable.getTableCapacity() * 4);
        System.out.println(" -ot:" + this.objectTable.getTableCapacity() * 4);
        System.out.println(" -ct:" + this.completeTable.getTableCapacity() * 4);
        System.out.println(" -vt:" + this.valueTable.getTableCapacity());
        System.out.println("-resourceTable:");
        System.out.println(" -resourceCount=" + this.resourceTable.getResourceCount());
        System.out.println(" -size=" + this.resourceTable.getTableSize());
        System.out.println(" -capacity=" + this.resourceTable.getTableCapacity());
        System.out.println(" -count=" + this.resourceTable.getTableCount());
        System.out.println(" -size=" + this.resourceTable.getTableSize());
    }

    @Override
    public void checkDirectReference(int dr) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        if (!ClusterTraits.statementIndexIsDirect(dr)) {
            throw new ValidationException("Reference is not direct. Reference=" + dr);
        }
        if (ClusterTraits.isFlat(dr)) {
            throw new ValidationException("Reference is flat. Reference=" + dr);
        }
        if (ClusterTraits.isLocal(dr)) {
            if (dr < 1 || dr > this.resourceTable.getUsedSize()) {
                throw new ValidationException("Illegal local reference. Reference=" + dr);
            }
        } else {
            int fi = ClusterTraits.getForeignIndexFromReference(dr);
            int ri = ClusterTraits.getResourceIndexFromForeignReference(dr);
            if (fi < 1 || fi > this.foreignTable.getUsedSize()) {
                throw new ValidationException("Illegal foreign reference. Reference=" + dr + " foreign index=" + fi);
            }
            if (ri < 1 || ri > ClusterTraits.getMaxNumberOfResources()) {
                throw new ValidationException("Illegal foreign reference. Reference=" + dr + " resource index=" + ri);
            }
        }
    }

    public void checkPredicateIndex(int pi) throws DatabaseException {
        if (this.deleted) {
            return;
        }
    }

    @Override
    public void checkObjectSetReference(int or) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        if (ClusterTraits.statementIndexIsDirect(or)) {
            throw new ValidationException("Illegal object set reference. Reference=" + or);
        }
        int oi = ClusterTraits.statementIndexGet(or);
        this.objectTable.checkObjectSetIndex(this, oi);
    }

    public void checkValueInit() throws DatabaseException {
        this.valueTable.checkValueInit();
    }

    public void checkValue(int capacity, int index) throws DatabaseException {
        this.valueTable.checkValue(capacity, index);
    }

    public void checkValueFini() throws DatabaseException {
        this.valueTable.checkValueFini();
    }

    @Override
    public void checkForeingIndex(int fi) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        if (fi < 1 || fi > this.foreignTable.getUsedSize()) {
            throw new ValidationException("Illegal foreign index=" + fi);
        }
    }

    public void checkCompleteSetReference(int cr) throws DatabaseException {
        if (!ClusterTraits.completeReferenceIsMultiple(cr)) {
            throw new ValidationException("Illegal complete set reference. Reference=" + cr);
        }
        int ci = cr;
        this.completeTable.checkCompleteSetIndex(this, ci);
    }

    public void check() throws DatabaseException {
        if (this.deleted) {
            return;
        }
    }

    public ClusterI.CompleteTypeEnum getCompleteType(int resourceKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return ClusterI.CompleteTypeEnum.NotComplete;
        }
        short resourceRef = this.getLocalReference(resourceKey);
        ClusterI.CompleteTypeEnum ct = this.resourceTable.getCompleteType(resourceRef);
        return ct;
    }

    public int getCompleteObjectKey(int resourceKey, ClusterSupport support) throws DatabaseException {
        int resourceIndex;
        int clusterIndex;
        if (this.deleted) {
            return 0;
        }
        short resourceIndexOld = this.getLocalReference(resourceKey);
        int completeRef = this.resourceTable.getCompleteObjectRef(resourceIndexOld);
        if (completeRef == 0) {
            throw new DatabaseException("Resource's complete object refernce is null. Resource key=" + resourceKey + ".");
        }
        ClusterI.CompleteTypeEnum completeType = this.resourceTable.getCompleteType(resourceIndexOld);
        if (completeType == ClusterI.CompleteTypeEnum.NotComplete) {
            throw new DatabaseException("Resource has multiple complete objects. Resource key=" + resourceKey + ".");
        }
        if (ClusterTraitsSmall.resourceRefIsLocal((short)completeRef)) {
            clusterIndex = this.clusterKey;
            resourceIndex = completeRef;
        } else {
            ResourceUID resourceUID = this.clusterMap.getForeignResourceUID((short)completeRef);
            ClusterBase c = support.getClusterByClusterUIDOrMake(resourceUID.asCID());
            clusterIndex = c.getClusterKey();
            resourceIndex = resourceUID.getIndex();
        }
        int key = ClusterTraits.createResourceKey((int)clusterIndex, (int)resourceIndex);
        return key;
    }

    public boolean isComplete(int resourceKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return false;
        }
        short resourceRef = this.getLocalReference(resourceKey);
        ClusterI.CompleteTypeEnum completeType = this.resourceTable.getCompleteType(resourceRef);
        boolean complete = completeType != ClusterI.CompleteTypeEnum.NotComplete;
        return complete;
    }

    public int getSingleObject(int resourceKey, int predicateKey, int objectIndex, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return 0;
        }
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            return this.resourceTable.getSingleObject(resourceIndex, support, pRef, pCompleteType, this.completeTable, this);
        }
        return this.objectTable.getSingleObject(objectIndex, support, this);
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, int objectIndex, SyncMultiProcedure<Resource> procedure, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            this.resourceTable.foreachObject((int)resourceIndex, graph, procedure, support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        this.objectTable.foreachObject(graph, objectIndex, procedure, this);
    }

    public <C> void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, int objectIndex, C context, SyncContextMultiProcedure<C, Resource> procedure, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            this.resourceTable.foreachObject(resourceIndex, graph, context, procedure, support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        this.objectTable.foreachObject(graph, objectIndex, context, procedure, (Modifier)this);
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, int objectIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return false;
        }
        if (objectIndex == 0) {
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
            short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, this, pRef, pCompleteType, this.completeTable);
        }
        return this.objectTable.foreachObject(objectIndex, procedure, context, support, (Modifier)this);
    }

    public int getSingleObject(int resourceKey, int predicateKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return 0;
        }
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
        int completeType = ClusterTraitsBase.getCompleteTypeIntFromResourceKey((int)predicateKey);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterI.CompleteTypeEnum.make((int)completeType);
        if (completeType > 0) {
            return this.resourceTable.getSingleObject(resourceIndex, support, pRef, pCompleteType, this.completeTable, this);
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject(resourceIndex, support, pRef, pCompleteType, this.completeTable, this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public <T> int getSingleObject(int resourceKey, ForPossibleRelatedValueProcedure<T> procedure, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return 0;
        }
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        int predicateKey = procedure.predicateKey;
        int clusterKey = ClusterTraitsBase.getClusterMaskFromResourceKey((int)resourceKey);
        short pRef = 0;
        if (procedure.clusterKey[0] == clusterKey) {
            pRef = (short)procedure.predicateReference[0];
        } else {
            pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            procedure.clusterKey[0] = clusterKey;
            procedure.predicateReference[0] = pRef;
        }
        ClusterI.CompleteTypeEnum pCompleteType = procedure.completeType;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.getSingleObject(resourceIndex, support, pRef, pCompleteType, this.completeTable, this);
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject(resourceIndex, support, pRef, pCompleteType, this.completeTable, this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public <C, T> int getSingleObject(int resourceKey, ForPossibleRelatedValueContextProcedure<C, T> procedure, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return 0;
        }
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        int predicateKey = procedure.predicateKey;
        int clusterKey = ClusterTraitsBase.getClusterMaskFromResourceKey((int)resourceKey);
        short pRef = 0;
        if (procedure.clusterKey[0] == clusterKey) {
            pRef = (short)procedure.predicateReference[0];
        } else {
            pRef = this.getInternalReferenceOrZero2(predicateKey, support);
            procedure.clusterKey[0] = clusterKey;
            procedure.predicateReference[0] = pRef;
        }
        ClusterI.CompleteTypeEnum pCompleteType = procedure.completeType;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.getSingleObject(resourceIndex, support, pRef, pCompleteType, this.completeTable, this);
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject(resourceIndex, support, pRef, pCompleteType, this.completeTable, this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, SyncMultiProcedure<Resource> procedure) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        SessionImplSocket session = (SessionImplSocket)graph.getSession();
        ClusterTranslator support = session.clusterTranslator;
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        short pRef = this.getInternalReferenceOrZero2(predicateKey, (ClusterSupport)support);
        int completeType = ClusterTraitsBase.getCompleteTypeIntFromResourceKey((int)predicateKey);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterI.CompleteTypeEnum.make((int)completeType);
        if (completeType > 0) {
            this.resourceTable.foreachObject((int)resourceIndex, graph, procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            this.resourceTable.foreachObject((int)resourceIndex, graph, procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        this.forObjects(graph, resourceKey, predicateKey, objectIndex, procedure, (ClusterSupport)support);
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, ForEachObjectProcedure procedure) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        int predicateKey = procedure.predicateKey;
        int clusterKey = ClusterTraitsBase.getClusterMaskFromResourceKey((int)resourceKey);
        int pRef = 0;
        if (procedure.clusterKey[0] == clusterKey) {
            pRef = procedure.predicateReference[0];
        } else {
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            pRef = this.getInternalReferenceOrZero2(predicateKey, (ClusterSupport)support);
            procedure.clusterKey[0] = clusterKey;
            procedure.predicateReference[0] = pRef;
        }
        ClusterI.CompleteTypeEnum pCompleteType = procedure.completeType;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.resourceTable.foreachObject((int)resourceIndex, graph, (SyncMultiProcedure<Resource>)procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.resourceTable.foreachObject((int)resourceIndex, graph, (SyncMultiProcedure<Resource>)procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        int hashBase = predicateIndex + this.predicateTable.offset;
        if (((int[])this.predicateTable.table)[hashBase - 1] < 0) {
            int objectIndex = TableIntArraySet2.get((int[])this.predicateTable.table, hashBase, pRef & 0xFFFF);
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.forObjects(graph, resourceKey, predicateKey, objectIndex, (SyncMultiProcedure<Resource>)procedure, (ClusterSupport)support);
        } else {
            int objectIndex = TableIntSet2.get((int[])this.predicateTable.table, hashBase, pRef & 0xFFFF);
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.forObjects(graph, resourceKey, predicateKey, objectIndex, (SyncMultiProcedure<Resource>)procedure, (ClusterSupport)support);
        }
    }

    public <C> void forObjects(ReadGraphImpl graph, int resourceKey, C context, ForEachObjectContextProcedure<C> procedure) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        int predicateKey = procedure.predicateKey;
        int clusterKey = ClusterTraitsBase.getClusterMaskFromResourceKey((int)resourceKey);
        int pRef = 0;
        if (procedure.clusterKey[0] == clusterKey) {
            pRef = procedure.predicateReference[0];
        } else {
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            pRef = this.getInternalReferenceOrZero2(predicateKey, (ClusterSupport)support);
            procedure.clusterKey[0] = clusterKey;
            procedure.predicateReference[0] = pRef;
        }
        ClusterI.CompleteTypeEnum pCompleteType = procedure.completeType;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.resourceTable.foreachObject(resourceIndex, graph, context, procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        int predicateIndex = (int)((long[])this.resourceTable.table)[(resourceIndex << 1) - 1 + this.resourceTable.offset] & 0xFFFFFF;
        if (predicateIndex == 0) {
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.resourceTable.foreachObject(resourceIndex, graph, context, procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, this);
            return;
        }
        int hashBase = predicateIndex + this.predicateTable.offset;
        if (((int[])this.predicateTable.table)[hashBase - 1] < 0) {
            int objectIndex = TableIntArraySet2.get((int[])this.predicateTable.table, hashBase, pRef & 0xFFFF);
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.forObjects(graph, resourceKey, predicateKey, objectIndex, context, (SyncContextMultiProcedure<C, Resource>)procedure, (ClusterSupport)support);
        } else {
            int objectIndex = TableIntSet2.get((int[])this.predicateTable.table, hashBase, pRef & 0xFFFF);
            SessionImplSocket session = (SessionImplSocket)graph.getSession();
            ClusterTranslator support = session.clusterTranslator;
            this.forObjects(graph, resourceKey, predicateKey, objectIndex, context, (SyncContextMultiProcedure<C, Resource>)procedure, (ClusterSupport)support);
        }
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return false;
        }
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)resourceKey);
        short pRef = this.getInternalReferenceOrZero2(predicateKey, support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, this, pRef, pCompleteType, this.completeTable);
        }
        int predicateIndex = this.resourceTable.getPredicateIndex(resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, this, pRef, pCompleteType, this.completeTable);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef & 0xFFFF);
        return this.forObjects(resourceKey, predicateKey, objectIndex, procedure, context, support);
    }

    public <Context> boolean forPredicates(int resourceKey, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return false;
        }
        if (this.proxy) {
            ClusterImpl cluster = this.clusterTable.load2(this.clusterId, this.clusterKey);
            return cluster.forPredicates(resourceKey, procedure, context, support);
        }
        short resourceIndex = this.getLocalReference(resourceKey);
        int predicateIndex = this.resourceTable.getPredicateIndex(resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.foreachPredicate(resourceIndex, procedure, context, support, this, this.completeTable);
        }
        boolean broken = this.resourceTable.foreachPredicate(resourceIndex, procedure, context, support, this, this.completeTable);
        if (broken) {
            return true;
        }
        return this.predicateTable.foreachPredicate(predicateIndex, procedure, context, support, this);
    }

    public ClusterI addRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        boolean ret;
        if (this.deleted) {
            return null;
        }
        if (this.proxy) {
            ClusterImpl cluster = this.clusterTable.load2(this.clusterId, this.clusterKey);
            return cluster.addRelation(sResourceKey, pResourceKey, oResourceKey, support);
        }
        try {
            short sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)2);
            short pri = this.getReferenceOrCreateIfForeign(pResourceKey, support, (byte)0);
            short ori = this.getReferenceOrCreateIfForeign(oResourceKey, support, (byte)0);
            ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
            ret = this.addRelationInternal(sri, pri, ori, completeType);
            this.calculateModifiedId();
        }
        catch (OutOfSpaceException outOfSpaceException) {
            ClusterI cluster2;
            boolean streamOff = support.getStreamOff();
            if (!streamOff) {
                support.cancelStatement((Object)this);
                support.setStreamOff(true);
            }
            ClusterBig cluster = this.toBig(support);
            if (!streamOff) {
                support.setStreamOff(false);
            }
            if (cluster != (cluster2 = cluster.addRelation(sResourceKey, pResourceKey, oResourceKey, support))) {
                throw new DatabaseException("Internal error, cluster mismatch.");
            }
            return cluster;
        }
        if (ret) {
            support.addStatement((Object)this);
            return this;
        }
        support.cancelStatement((Object)this);
        return null;
    }

    public boolean removeRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return false;
        }
        short sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)3);
        short pri = this.getInternalReferenceOrZeroAnd(pResourceKey, support, (byte)0);
        short ori = this.getInternalReferenceOrZeroAnd(oResourceKey, support, (byte)0);
        boolean ret = false;
        if (pri != 0 && ori != 0) {
            ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
            ret = this.removeRelationInternal(sri, pri, ori, completeType, support);
            this.calculateModifiedId();
        }
        if (ret) {
            support.removeStatement((Object)this);
        } else {
            support.cancelStatement((Object)this);
        }
        return ret;
    }

    public void denyRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        short s = this.checkResourceKeyIsOursAndGetResourceIndexIf(sResourceKey, support);
        ResourceReferenceAndCluster p = this.checkResourceKeyAndGetResourceIndexIf(pResourceKey, support);
        ResourceReferenceAndCluster o = this.checkResourceKeyAndGetResourceIndexIf(oResourceKey, support);
        if (s == 0 || p.reference == 0 || o.reference == 0) {
            return;
        }
        ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
        boolean ret = this.removeRelationInternal(s, p.reference, o.reference, completeType, support);
        if (ret) {
            support.addStatementIndex((Object)this, sResourceKey, this.getClusterUID(), (byte)3);
            support.addStatementIndex((Object)this, pResourceKey, p.clusterUID, (byte)0);
            support.addStatementIndex((Object)this, oResourceKey, o.clusterUID, (byte)0);
            support.removeStatement((Object)this);
        }
        this.calculateModifiedId();
    }

    public InputStream getValueStream(int resourceKey, ClusterSupport support) throws DatabaseException {
        byte[] buffer;
        block4: {
            if (this.deleted) {
                return null;
            }
            short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
            try {
                buffer = this.resourceTable.getValue(this.valueTable, resourceIndex);
                if (buffer != null) break block4;
                return null;
            }
            catch (ExternalValueException externalValueException) {
                return support.getValueStreamEx((int)resourceIndex, this.clusterId);
            }
        }
        return new ValueStream(buffer);
    }

    public byte[] getValue(int resourceKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return null;
        }
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
        try {
            return this.resourceTable.getValue(this.valueTable, resourceIndex);
        }
        catch (ExternalValueException externalValueException) {
            return support.getValueEx((int)resourceIndex, this.clusterId);
        }
        catch (RuntimeException e) {
            throw new DatabaseException("Fatal error while trying to get value from database", (Throwable)e);
        }
    }

    public boolean hasValue(int resourceKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return false;
        }
        if (this.proxy) {
            ClusterImpl cluster = this.clusterTable.load2(this.clusterId, this.clusterKey);
            return cluster.hasValue(resourceKey, support);
        }
        short resourceIndex = this.getLocalReference(resourceKey);
        return this.resourceTable.hasValue(resourceIndex);
    }

    public boolean removeValue(int resourceKey, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return false;
        }
        short resourceIndex = this.getLocalReferenceAnd(resourceKey, support, (byte)5);
        support.removeValue((Object)this);
        this.calculateModifiedId();
        return this.resourceTable.removeValue(this.valueTable, resourceIndex);
    }

    public ClusterI setValue(int rResourceId, byte[] value, int length, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return null;
        }
        short resourceIndex = this.getLocalReferenceAnd(rResourceId, support, (byte)4);
        support.setValue((Object)this, this.getClusterId(), value, length);
        try {
            this.resourceTable.setValue(this.valueTable, resourceIndex, value, length);
            this.calculateModifiedId();
            return this;
        }
        catch (OutOfSpaceException outOfSpaceException) {
            boolean streamOff = support.getStreamOff();
            if (!streamOff) {
                support.setStreamOff(true);
            }
            ClusterBig cluster = this.toBig(support);
            cluster.setValue(rResourceId, value, length, support);
            if (!streamOff) {
                support.setStreamOff(false);
            }
            return cluster;
        }
    }

    public ClusterI modiValueEx(int rResourceId, long voffset, int length, byte[] value, int offset, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return null;
        }
        short resourceIndex = this.getLocalReferenceAnd(rResourceId, support, (byte)6);
        support.modiValue((Object)this, this.getClusterId(), voffset, length, value, offset);
        this.resourceTable.setValueEx(this.valueTable, resourceIndex);
        this.calculateModifiedId();
        return this;
    }

    public byte[] readValueEx(int rResourceId, long voffset, int length, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return null;
        }
        short resourceIndex = this.getLocalReference(rResourceId);
        boolean isExternal = this.resourceTable.isValueEx(this.valueTable, resourceIndex);
        if (!isExternal) {
            throw new DatabaseException("ClusterI.readValue supported only for external value. Resource key=" + rResourceId);
        }
        return support.getValueEx((int)resourceIndex, this.getClusterId(), voffset, length);
    }

    public long getValueSizeEx(int rResourceId, ClusterSupport support) throws DatabaseException, ExternalValueException {
        if (this.deleted) {
            return 0L;
        }
        short resourceIndex = this.getLocalReference(rResourceId);
        boolean isExternal = this.resourceTable.isValueEx(this.valueTable, resourceIndex);
        if (!isExternal) {
            throw new ExternalValueException("ClusterI.getValueSizeEx supported only for external value. Resource key=" + rResourceId);
        }
        return support.getValueSizeEx((int)resourceIndex, this.getClusterId());
    }

    public void setValueEx(int rResourceId) throws DatabaseException {
        short resourceIndex = this.getLocalReference(rResourceId);
        this.resourceTable.setValueEx(this.valueTable, resourceIndex);
    }

    public int createResource(ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return 0;
        }
        if (this.proxy) {
            ClusterImpl cluster = this.clusterTable.load2(this.clusterId, this.clusterKey);
            return cluster.createResource(support);
        }
        short resourceIndex = this.resourceTable.createResource();
        this.calculateModifiedId();
        support.createResource((Object)this, resourceIndex, this.getClusterId());
        return ClusterTraits.createResourceKey((int)this.clusterKey, (int)resourceIndex);
    }

    public boolean hasResource(int resourceKey, ClusterSupport support) {
        short resourceIndex;
        if (this.proxy) {
            try {
                ClusterImpl cluster = this.clusterTable.load2(this.clusterId, this.clusterKey);
                return cluster.hasResource(resourceKey, support);
            }
            catch (DatabaseException databaseException) {
                LOGGER.error("Failed to load cluster with clusterId " + this.clusterId);
                return false;
            }
        }
        if (this.deleted) {
            return false;
        }
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            return false;
        }
        try {
            resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        }
        catch (DatabaseException databaseException) {
            return false;
        }
        return resourceIndex > 0 & resourceIndex <= this.resourceTable.getTableCount();
    }

    public int getNumberOfResources(ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return 0;
        }
        if (this.proxy) {
            ClusterImpl cluster = this.clusterTable.load2(this.clusterId, this.clusterKey);
            return cluster.getNumberOfResources(support);
        }
        return this.resourceTable.getUsedSize();
    }

    public int getNumberOfResources() {
        if (this.deleted || this.proxy) {
            return 0;
        }
        return this.resourceTable.getUsedSize();
    }

    public long getUsedSpace() {
        if (this.deleted) {
            return 0L;
        }
        if (this.isEmpty()) {
            return 0L;
        }
        long rt = this.resourceTable.getTableCapacity() * 8 + 8;
        long ft = this.foreignTable.getTableCapacity() * 8;
        long pt = this.predicateTable.getTableCapacity() * 4;
        long ot = this.objectTable.getTableCapacity() * 4;
        long ct = this.completeTable.getTableCapacity() * 4;
        long vt = this.valueTable.getTableCapacity() * 1;
        long cm = this.clusterMap.getUsedSpace();
        return rt + ft + pt + ot + ct + vt + cm;
    }

    public boolean isEmpty() {
        if (this.deleted) {
            return true;
        }
        if (this.resourceTable == null) {
            return true;
        }
        return this.resourceTable.getTableCount() == 0;
    }

    public void printDebugInfo(String message, ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return;
        }
        throw new DatabaseException("Not implemented!");
    }

    private short getInternalReferenceOrZero2(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
        if (!ClusterTraitsBase.isCluster((int)this.clusterBits, (int)resourceKey)) {
            return this.clusterMap.getForeignReferenceOrZero(resourceKey);
        }
        return resourceIndex;
    }

    private short getInternalReferenceOrZeroAnd(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterBase foreignCluster = support.getClusterByClusterKey(clusterKey);
            ClusterUID clusterUID = foreignCluster.getClusterUID();
            short foreignRef = this.clusterMap.getForeignReferenceOrZero(resourceKey);
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            return foreignRef;
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private final short getLocalReference(int resourceKey) throws DatabaseException {
        return ClusterTraits.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
    }

    private final short getLocalReferenceAnd(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private short checkResourceKeyIsOursAndGetResourceIndexIf(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterShortId = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterShortId) {
            return 0;
        }
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        return resourceIndex;
    }

    private short getReferenceOrCreateIfForeign(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterBase foreignCluster = support.getClusterByClusterKey(clusterKey);
            ClusterUID clusterUID = foreignCluster.getClusterUID();
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            short ref = this.clusterMap.getForeignReferenceOrCreateByResourceKey(resourceKey, clusterUID);
            return ref;
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private ResourceReferenceAndCluster checkResourceKeyAndGetResourceIndexIf(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterBase foreignCluster = support.getClusterByClusterKey(clusterKey);
            ClusterUID clusterUID = foreignCluster.getClusterUID();
            short ref = this.clusterMap.getForeignReferenceOrZero(resourceKey);
            return new ResourceReferenceAndCluster(ref, clusterUID);
        }
        return new ResourceReferenceAndCluster(resourceIndex, this.getClusterUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int execute(int resourceReference) throws DatabaseException {
        int key;
        if (this.deleted) {
            return 0;
        }
        short resourceRef = (short)resourceReference;
        if (ClusterTraitsSmall.resourceRefIsLocal(resourceRef)) {
            key = this.clusterBits | resourceRef;
        } else {
            ClusterSmall clusterSmall = this;
            synchronized (clusterSmall) {
                this.foreignTable.fillResourceUID(ClusterTraitsSmall.resourceRefGetForeignIndex(resourceRef), this);
                key = ClusterTraitsBase.createResourceKey((int)this.clusterSupport.getClusterKeyByClusterUIDOrMake(this.clusterUID1, this.clusterUID2), (int)this.executeIndex);
            }
        }
        return key;
    }

    private boolean addRelationInternal(short sReference, short pReference, short oReference, ClusterI.CompleteTypeEnum completeType) throws DatabaseException {
        int predicateIndex = this.resourceTable.addStatement(sReference, pReference, oReference, this.predicateTable, this.objectTable, completeType, this.completeTable);
        if (predicateIndex == 0) {
            return true;
        }
        if (predicateIndex < 0) {
            return false;
        }
        int newPredicateIndex = this.predicateTable.addPredicate(predicateIndex, 0xFFFF & pReference, 0xFFFF & oReference, this.objectTable);
        if (newPredicateIndex == 0) {
            return false;
        }
        if (predicateIndex != newPredicateIndex) {
            this.resourceTable.setPredicateIndex(sReference, newPredicateIndex);
        }
        return true;
    }

    private boolean removeRelationInternal(int sResourceIndex, short pResourceIndex, short oResourceIndex, ClusterI.CompleteTypeEnum completeType, ClusterSupport support) throws DatabaseException {
        int predicateIndex = this.resourceTable.getPredicateIndex(sResourceIndex);
        if (predicateIndex == 0 || ClusterI.CompleteTypeEnum.NotComplete != completeType) {
            return this.resourceTable.removeStatementFromCache(sResourceIndex, pResourceIndex, oResourceIndex, completeType, this.completeTable);
        }
        PredicateTable.Status ret = this.predicateTable.removePredicate(predicateIndex, 0xFFFF & pResourceIndex, 0xFFFF & oResourceIndex, this.objectTable);
        switch (ret) {
            case NothingRemoved: {
                return false;
            }
            case PredicateRemoved: {
                if (this.predicateTable.getPredicateSetSize(predicateIndex) != 0) break;
                this.resourceTable.setPredicateIndex(sResourceIndex, 0);
            }
        }
        this.resourceTable.removeStatement(sResourceIndex, pResourceIndex, oResourceIndex, completeType, this.completeTable, this.predicateTable, this.objectTable, support);
        return true;
    }

    public void load() {
        if (this.deleted) {
            return;
        }
        try {
            this.clusterTable.load2(this.clusterId, this.clusterKey);
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to load cluster with clusterId " + this.clusterId, (Throwable)e);
        }
    }

    public void load(Consumer<DatabaseException> r) {
        if (this.deleted) {
            return;
        }
        try {
            this.clusterTable.load2(this.clusterId, this.clusterKey);
        }
        catch (DatabaseException e) {
            r.accept(e);
        }
    }

    public boolean contains(int resourceKey) {
        if (this.deleted) {
            return false;
        }
        return ClusterTraitsBase.isCluster((int)this.clusterBits, (int)resourceKey);
    }

    public void load(ClusterSupport support, Runnable callback) {
        if (this.deleted) {
            return;
        }
        try {
            this.clusterTable.load2(this.clusterId, this.clusterKey);
            callback.run();
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to load cluster with clusterId " + this.clusterId, (Throwable)e);
        }
    }

    public ClusterI getClusterByResourceKey(int resourceKey, ClusterSupport support) {
        if (this.deleted) {
            return null;
        }
        throw new Error();
    }

    public void increaseReferenceCount(int amount) {
        if (this.deleted) {
            return;
        }
        throw new Error();
    }

    public void decreaseReferenceCount(int amount) {
        if (this.deleted) {
            return;
        }
        throw new Error();
    }

    public int getReferenceCount() {
        if (this.deleted) {
            return 0;
        }
        throw new Error();
    }

    public void releaseMemory() {
    }

    public void compact() {
        if (this.deleted) {
            return;
        }
        this.clusterMap.compact();
    }

    @Override
    public boolean isLoaded() {
        return !this.proxy || this.deleted;
    }

    public ClusterImpl tryLoad(SessionImplSocket sessionImpl) throws DatabaseException {
        if (this.deleted) {
            return this;
        }
        return this.clusterTable.tryLoad(this.clusterId, this.clusterKey);
    }

    @Override
    public ClusterBig toBig(ClusterSupport support) throws DatabaseException {
        if (this.deleted) {
            return null;
        }
        ClusterBig big = new ClusterBig(this.getClusterUID(), this.clusterKey, support);
        big.setImportance(this.importance);
        big.cc = this.cc;
        big.cc.clusterImpl = this;
        this.resourceTable.toBig(big, support, this);
        big.foreignLookup = this.foreignLookup;
        big.change = this.change;
        this.cc = null;
        this.foreignLookup = null;
        this.change = null;
        return big;
    }

    public ClusterI.ClusterTypeEnum getType() {
        return ClusterI.ClusterTypeEnum.SMALL;
    }

    public boolean getImmutable() {
        if (this.deleted) {
            return false;
        }
        if (this.resourceTable == null) {
            return false;
        }
        int status = this.resourceTable.getClusterStatus();
        return (status & 1) == 1;
    }

    public void setImmutable(boolean immutable, ClusterSupport support) {
        if (this.deleted) {
            return;
        }
        if (this.resourceTable != null) {
            int status = this.resourceTable.getClusterStatus();
            status = immutable ? (status |= 1) : (status &= 0xFFFFFFFE);
            this.resourceTable.setClusterStatus(status);
        }
        support.setImmutable((Object)this, immutable);
    }

    public boolean getDeleted() {
        if (this.deleted) {
            return true;
        }
        int status = this.resourceTable.getClusterStatus();
        return (status & 2) == 2;
    }

    public void setDeleted(boolean set, ClusterSupport support) {
        this.deleted = set;
        if (this.resourceTable != null) {
            int status = this.resourceTable.getClusterStatus();
            status = set ? (status |= 2) : (status &= 0xFFFFFFFD);
            this.resourceTable.setClusterStatus(status);
        }
        if (support != null) {
            support.setDeleted((Object)this, set);
        }
    }

    public String toString() {
        if (this.deleted) {
            return "ClusterSmall[" + this.getClusterId() + " - has been deleted or hasn't been created.]";
        }
        try {
            ForeignTableSmall ft = this.foreignTable;
            if (ft == null) {
                return "ClusterSmall[" + this.getClusterId() + " - " + this.getNumberOfResources() + "]";
            }
            TIntShortHashMap map = ft.getResourceHashMap();
            TIntHashSet set = new TIntHashSet();
            map.forEachKey(value -> {
                set.add(value & 0xFFFFF000);
                return true;
            });
            return "ClusterSmall[" + this.getClusterId() + " - " + this.getNumberOfResources() + " - " + this.foreignTable.getResourceHashMap().size() + " - " + set.size() + "]";
        }
        catch (Throwable throwable) {
            return "ClusterSmall[" + this.getNumberOfResources() + "]";
        }
    }

    public Table<?> getPredicateTable() {
        return this.predicateTable;
    }

    public Table<?> getForeignTable() {
        return this.foreignTable;
    }

    public int makeResourceKey(int pRef) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public Table<?> getCompleteTable() {
        return this.completeTable;
    }

    public Table<?> getValueTable() {
        return this.valueTable;
    }

    public Table<?> getObjectTable() {
        return this.objectTable;
    }

    private class ResourceReferenceAndCluster {
        public final short reference;
        public final ClusterUID clusterUID;

        ResourceReferenceAndCluster(short reference, ClusterUID clusterUID) {
            this.reference = reference;
            this.clusterUID = clusterUID;
        }
    }
}

