/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import fi.vtt.simantics.procore.internal.Change;
import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.util.UUID;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidClusterException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.Modifier;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ClusteringSupport;

public abstract class ClusterImpl
extends ClusterBase
implements Modifier,
ClusterCollectorPolicy.CollectorCluster {
    private static final int LONG_HEADER_SIZE = 7;
    private static final long LONG_HEADER_VERSION = 1L;
    static final boolean DEBUG = false;
    public Change change = new Change();
    public ClusterChange cc;
    public byte[] foreignLookup;
    private boolean dirtySizeInBytes = true;
    private long sizeInBytes = 0L;
    protected ClusterTable clusterTable;

    protected static ClusterUID checkValidity(long type, long[] longs, int[] ints, byte[] bytes) throws InvalidClusterException {
        if (longs.length < 7) {
            throw new InvalidClusterException("Header size mismatch. Expected=7, got=" + longs.length);
        }
        if (longs[0] != type) {
            throw new InvalidClusterException("Type mismatch. Expected=" + type + ", got=" + longs[0]);
        }
        if (longs[1] != 1L) {
            throw new InvalidClusterException("Header size mismatch. Expected=1, got=" + longs[1]);
        }
        return ClusterUID.make((long)longs[2], (long)longs[3]);
    }

    protected static ClusteringSupport.Id getUniqueId(long[] longs) {
        return new ClusterBase.IdImpl(new UUID(longs[3], longs[4]));
    }

    public ClusterImpl(ClusterUID clusterUID, int clusterKey, ClusterSupport support) {
        super(support, clusterUID, clusterKey);
        this.clusterTable = ((SessionImplSocket)support.getSession()).clusterTable;
    }

    public static ClusterImpl make(ClusterUID clusterUID, int clusterKey, ClusterSupport support) {
        return new ClusterSmall(clusterUID, clusterKey, support);
    }

    public static ClusterSmall proxy(ClusterUID clusterUID, int clusterKey, long clusterId, ClusterSupport support) {
        return new ClusterSmall(clusterUID, clusterKey, ((SessionImplSocket)support.getSession()).clusterTable, support);
    }

    public static ClusterImpl make(long[] longs, int[] ints, byte[] bytes, ClusterSupport support, int clusterKey) throws DatabaseException {
        if (longs[0] == 0L) {
            return new ClusterBig(longs, ints, bytes, support, clusterKey);
        }
        return new ClusterSmall(longs, ints, bytes, support, clusterKey);
    }

    public abstract ClusterBig toBig(ClusterSupport var1) throws DatabaseException;

    public abstract void checkDirectReference(int var1) throws DatabaseException;

    public abstract void checkForeingIndex(int var1) throws DatabaseException;

    public abstract void checkObjectSetReference(int var1) throws DatabaseException;

    public boolean hasVirtual() {
        return this.clusterTable.hasVirtual(this.clusterKey);
    }

    public boolean isWriteOnly() {
        return false;
    }

    public boolean isLoaded() {
        return true;
    }

    public void resized() {
        this.dirtySizeInBytes = true;
        this.clusterTable.setDirtySizeInBytes(true);
    }

    public long getCachedSize() {
        if (this.dirtySizeInBytes) {
            long oldSize = this.sizeInBytes;
            if (oldSize > 0L) {
                this.clusterTable.adjustCachedSize(-oldSize, (ClusterI)this);
            }
            try {
                this.sizeInBytes = this.getUsedSpace();
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            if (this.sizeInBytes != 0L) {
                this.clusterTable.adjustCachedSize(this.sizeInBytes, (ClusterI)this);
            }
            this.dirtySizeInBytes = false;
        }
        return this.sizeInBytes;
    }

    protected void calculateModifiedId() {
    }

    public IClusterTable getClusterTable() {
        return this.clusterTable;
    }
}

