/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.State;
import java.util.TreeMap;
import org.simantics.db.Metadata;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.MetadataUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ImmutableException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.MemWatch;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.VirtualGraphImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteResult;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ByteReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteSupportImpl
implements WriteSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteSupportImpl.class);
    private final SessionImplSocket session;
    private final QueryProcessor queryProcessor;
    private final State state;
    private final QuerySupport querySupport;
    private final TreeMap<String, byte[]> metadata;
    private WriteTraits writeTraits = null;

    WriteSupportImpl(SessionImplSocket session) {
        this.session = session;
        this.queryProcessor = session.getQueryProvider2();
        this.state = session.state;
        this.querySupport = session.querySupport;
        this.metadata = new TreeMap();
        assert (this.session != null);
        assert (this.queryProcessor != null);
        assert (this.state != null);
        assert (this.querySupport != null);
    }

    public void flushCluster() {
        this.session.clusterTable.flushCluster(this.session.graphSession);
        if (this.session.defaultClusterSet != null) {
            long resourceId = this.session.defaultClusterSet.getResourceId();
            this.session.clusterSetsSupport.setActiveCluster(resourceId, -1L);
        }
    }

    public void flushCluster(Resource r) {
        this.session.clusterStream.reallyFlush();
    }

    public boolean writeOnly() {
        return this.session.writeOnly;
    }

    public void flush(boolean intermediate) {
        if (!this.session.state.isWriteTransaction()) {
            throw new IllegalStateException("Can only flush during transaction.");
        }
        this.gc();
    }

    public final void claim(VirtualGraph provider, Resource subject, Resource predicate, Resource object) throws ServiceException {
        this.claim(provider, this.querySupport.getId(subject), this.querySupport.getId(predicate), this.querySupport.getId(object));
    }

    public final void claim(VirtualGraph provider, int subject, int predicate, int object) throws ServiceException {
        provider = this.session.getProvider(provider);
        if (this.writeOnly()) {
            if (provider != null) {
                ((VirtualGraphImpl)provider).claim(subject, predicate, object);
                this.queryProcessor.updateStatements(subject, predicate);
                this.session.clientChanges.claim(subject, predicate, object);
            } else {
                this.claimImpl2(subject, predicate, object);
            }
        } else {
            if (provider != null) {
                ((VirtualGraphImpl)provider).claim(subject, predicate, object);
                this.queryProcessor.updateStatements(subject, predicate);
                this.session.clientChanges.claim(subject, predicate, object);
            } else {
                this.claimImpl(subject, predicate, object);
            }
            this.queryProcessor.releaseWrite((ReadGraphImpl)this.session.writeState.getGraph());
        }
    }

    public void setValue(VirtualGraph provider, Resource resource, byte[] value) throws ServiceException {
        provider = this.session.getProvider(provider);
        if (this.writeOnly()) {
            if (provider != null) {
                ((VirtualGraphImpl)provider).claimValue(((ResourceImpl)resource).id, value, value.length);
                this.queryProcessor.updateValue(this.querySupport.getId(resource));
                this.session.clientChanges.claimValue(resource);
            } else {
                try {
                    this.addSetValue(((ResourceImpl)resource).id, value, value.length);
                }
                catch (DatabaseException e) {
                    LOGGER.error("writeOnly setValue({}, {}, byte[{}]) failed", new Object[]{provider, resource, value.length, e});
                }
            }
        } else {
            if (provider != null) {
                ((VirtualGraphImpl)provider).claimValue(((ResourceImpl)resource).id, value, value.length);
                this.queryProcessor.updateValue(this.querySupport.getId(resource));
                this.session.clientChanges.claimValue(resource);
            } else {
                try {
                    this.addSetValue(((ResourceImpl)resource).id, value, value.length);
                }
                catch (DatabaseException e) {
                    LOGGER.error("setValue({}, {}, byte[{}]) failed", new Object[]{provider, resource, value.length, e});
                }
            }
            this.queryProcessor.releaseWrite((ReadGraphImpl)this.session.writeState.getGraph());
        }
    }

    public Resource createResource(VirtualGraph provider) throws DatabaseException {
        if (provider != null) {
            int newId = ((VirtualGraphImpl)provider).newResource(false);
            return new ResourceImpl((ResourceSupport)this.session.resourceSupport, newId);
        }
        return this.session.getNewResource();
    }

    public Resource createResource(VirtualGraph provider, long clusterId) throws DatabaseException {
        assert (provider == null);
        return this.session.getNewResource(clusterId);
    }

    public Resource createResource(VirtualGraph provider, Resource clusterSet) throws DatabaseException {
        assert (provider == null);
        assert (clusterSet != null);
        return this.session.getNewResource(clusterSet);
    }

    public void createClusterSet(VirtualGraph provider, Resource clusterSet, boolean immutable) throws DatabaseException {
        assert (provider == null);
        assert (clusterSet != null);
        this.session.getNewClusterSet(clusterSet);
    }

    public void setClusterSetImmutability(VirtualGraph provider, Resource clusterSet, boolean immutable) throws DatabaseException {
        assert (provider == null);
        assert (clusterSet != null);
        this.session.setClusterSetImmutability(clusterSet, immutable);
    }

    public boolean hasClusterSet(VirtualGraph dummy, Resource clusterSet) throws ServiceException {
        return this.session.containsClusterSet(clusterSet);
    }

    public Resource setDefaultClusterSet(Resource clusterSet) throws ServiceException {
        return this.session.setDefaultClusterSet4NewResource(clusterSet);
    }

    public void setupClusters() {
        try {
            this.setDefaultClusterSet(this.session.getDefaultMutableClusterSet());
        }
        catch (ServiceException e) {
            LOGGER.error("Failed to reset default cluster set for new WriteGraph", (Throwable)e);
        }
    }

    public void denyValue(VirtualGraph provider, Resource resource) throws ServiceException {
        if ((provider = this.session.getProvider(provider)) == null) {
            int key = ((ResourceImpl)resource).id;
            Object cluster = this.session.clusterTable.getClusterByResourceKey(key);
            if (cluster.getImmutable() && (this.session.serviceMode & 1) == 0 && key != this.queryProcessor.getRootLibrary()) {
                throw new ImmutableException("Trying to modify immutable resource key=" + key);
            }
            try {
                cluster.removeValue(key, (ClusterSupport)this.session.clusterTranslator);
            }
            catch (DatabaseException e) {
                LOGGER.error("denyValue({}, {}) failed", new Object[]{provider, resource, e});
                return;
            }
            this.queryProcessor.updateValue(key);
            this.session.clientChanges.claimValue(resource);
        } else {
            ((VirtualGraphImpl)provider).denyValue(((ResourceImpl)resource).id);
            this.queryProcessor.updateValue(this.querySupport.getId(resource));
            this.session.clientChanges.claimValue(resource);
        }
        if (!this.writeOnly()) {
            this.queryProcessor.releaseWrite((ReadGraphImpl)this.session.writeState.getGraph());
        }
    }

    public boolean removeStatement(VirtualGraph provider, Resource subject, Resource predicate, Resource object) throws ServiceException {
        boolean ret = true;
        if (this.writeOnly()) {
            if (provider != null) {
                ((VirtualGraphImpl)provider).deny(this.querySupport.getId(subject), this.querySupport.getId(predicate), this.querySupport.getId(object));
                this.queryProcessor.updateStatements(this.querySupport.getId(subject), this.querySupport.getId(predicate));
            } else {
                ret = this.removeStatement(this.querySupport.getId(subject), this.querySupport.getId(predicate), this.querySupport.getId(object));
            }
        } else if (provider != null) {
            ((VirtualGraphImpl)provider).deny(this.querySupport.getId(subject), this.querySupport.getId(predicate), this.querySupport.getId(object));
            this.queryProcessor.updateStatements(this.querySupport.getId(subject), this.querySupport.getId(predicate));
            this.queryProcessor.releaseWrite((ReadGraphImpl)this.session.writeState.getGraph());
        } else {
            int sid = this.querySupport.getId(subject);
            int pid = this.querySupport.getId(predicate);
            int oid = this.querySupport.getId(object);
            if (sid < 0 || pid < 0 || oid < 0) {
                return false;
            }
            ret = this.removeStatement(sid, pid, oid);
            this.queryProcessor.releaseWrite((ReadGraphImpl)this.session.writeState.getGraph());
        }
        this.session.clientChanges.deny(subject, predicate, object);
        return ret;
    }

    public synchronized void performWriteRequest(WriteGraph graph_, Write request) throws DatabaseException {
        WriteGraphImpl graph = (WriteGraphImpl)graph_;
        try {
            request.perform((WriteGraph)graph);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.queryProcessor.propagateChangesInQueryCache((ReadGraphImpl)graph);
        if (graph.getProvider() == null) {
            this.state.commitAndContinue(graph, this.session.clusterStream, (WriteTraits)request);
        }
    }

    public synchronized <T> T performWriteRequest(WriteGraph graph_, WriteResult<T> request) throws DatabaseException {
        WriteGraphImpl graph = (WriteGraphImpl)graph_;
        Object result = null;
        Throwable t = null;
        try {
            result = request.perform((WriteGraph)graph);
        }
        catch (Throwable t2) {
            t = t2;
        }
        this.queryProcessor.propagateChangesInQueryCache((ReadGraphImpl)graph);
        if (graph.getProvider() == null) {
            this.state.commitAndContinue(graph, this.session.clusterStream, (WriteTraits)request);
        }
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        return (T)result;
    }

    public synchronized void performWriteRequest(WriteGraph graph, WriteOnly request) throws DatabaseException {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        try {
            try {
                this.session.acquireWriteOnly();
                request.perform((WriteOnlyGraph)graph);
                if (graph.getProvider() == null) {
                    this.state.commitAndContinue(this.session.writeState.getGraph(), this.session.clusterStream, (WriteTraits)request);
                }
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        finally {
            this.queryProcessor.propagateChangesInQueryCache(impl);
            this.session.releaseWriteOnly(impl);
        }
    }

    public void gc() {
        if (MemWatch.isLowOnMemory()) {
            this.session.clusterTable.gc();
            this.queryProcessor.gc(0, Integer.MAX_VALUE);
            System.gc();
        }
    }

    public void claimValue(VirtualGraph provider, Resource resource, byte[] value) throws DatabaseException {
        this.claimValue(provider, ((ResourceImpl)resource).id, value, value.length);
    }

    public void claimValue(VirtualGraph provider, int resource, byte[] value, int length) throws DatabaseException {
        provider = this.session.getProvider(provider);
        if (this.writeOnly()) {
            if (provider != null) {
                ((VirtualGraphImpl)provider).claimValue(resource, value, length);
                this.queryProcessor.updateValue(resource);
                this.session.clientChanges.claimValue(resource);
            } else {
                this.addSetValue(resource, value, length);
            }
        } else if (provider != null) {
            ((VirtualGraphImpl)provider).claimValue(resource, value, length);
            this.queryProcessor.updateValue(resource);
            this.session.clientChanges.claimValue(resource);
            this.queryProcessor.releaseWrite((ReadGraphImpl)this.session.writeState.getGraph());
        } else {
            try {
                try {
                    this.addSetValue(resource, value, length);
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new DatabaseException(t);
                }
            }
            finally {
                this.queryProcessor.releaseWrite((ReadGraphImpl)this.session.writeState.getGraph());
            }
        }
    }

    public void claimValue(VirtualGraph provider, Resource resource, ByteReader reader, int amount) throws DatabaseException {
        this.claimValue(provider, resource, reader.readBytes(null, amount));
    }

    public <T> void addMetadata(Metadata data) throws ServiceException {
        MetadataUtils.addMetadata((Session)this.session, this.metadata, (Metadata)data);
    }

    public <T extends Metadata> T getMetadata(Class<T> clazz) throws ServiceException {
        return (T)MetadataUtils.getMetadata((Session)this.session, this.metadata, clazz);
    }

    public TreeMap<String, byte[]> getMetadata() {
        return this.metadata;
    }

    public void commitDone(WriteTraits writeTraits, long csid) {
        this.metadata.clear();
        if (this.writeTraits == writeTraits) {
            this.session.graphSession.undoContext.clear();
            this.writeTraits = null;
        }
    }

    public int clearMetadata() {
        int ret = this.metadata.size();
        this.metadata.clear();
        return ret;
    }

    public void clearUndoList(WriteTraits writeTraits) {
        this.writeTraits = writeTraits;
    }

    public void startUndo() {
        this.session.state.setCombine(false);
    }

    private void addSetValue(int subject, byte[] value, int length) throws DatabaseException {
        Object cluster = this.session.clusterTable.getClusterByResourceKey(subject);
        if (cluster.getImmutable() && (this.session.serviceMode & 1) == 0 && subject != this.queryProcessor.getRootLibrary()) {
            throw new ImmutableException("Trying to modify immutable resource key=" + subject);
        }
        ClusterI cluster2 = cluster.setValue(subject, value, length, (ClusterSupport)this.session.clusterTranslator);
        if (cluster2 != cluster) {
            this.session.clusterTable.replaceCluster(cluster2);
        }
        this.session.clientChanges.claimValue(subject);
        if (cluster2.isWriteOnly()) {
            return;
        }
        this.queryProcessor.updateValue(subject);
    }

    private final void claimImpl(int subject, int predicate, int object) throws ServiceException {
        assert (subject != 0);
        assert (predicate != 0);
        assert (object != 0);
        ClusterImpl cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject));
        assert (cluster != null);
        if (cluster.getImmutable() && (this.session.serviceMode & 1) == 0 && subject != this.queryProcessor.getRootLibrary()) {
            throw new ImmutableException("Trying to modify immutable resource key=" + subject);
        }
        try {
            ClusterI c = cluster.addRelation(subject, predicate, object, (ClusterSupport)this.session.clusterTranslator);
            if (c != null && c != cluster) {
                this.session.clusterTable.replaceCluster(c);
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("claimImpl({}, {}, {}) failed", new Object[]{subject, predicate, object, e});
            throw new RuntimeException(e);
        }
        this.queryProcessor.updateStatements(subject, predicate);
        this.session.clientChanges.claim(subject, predicate, object);
    }

    private final void claimImpl2(int subject, int predicate, int object) {
        assert (subject != 0);
        assert (predicate != 0);
        assert (object != 0);
        Object cluster = this.session.clusterTable.getClusterByResourceKey(subject);
        try {
            ClusterI c = cluster.addRelation(subject, predicate, object, (ClusterSupport)this.session.clusterTranslator);
            if (c != null && c != cluster) {
                this.session.clusterTable.replaceCluster(c);
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("claimImpl2({}, {}, {}) failed", new Object[]{subject, predicate, object, e});
        }
        if (cluster.isWriteOnly()) {
            return;
        }
        this.queryProcessor.updateStatements(subject, predicate);
    }

    private boolean removeStatement(int subject, int predicate, int object) throws ImmutableException {
        assert (subject != 0);
        assert (predicate != 0);
        assert (object != 0);
        Object cluster = this.session.clusterTable.getClusterByResourceKey(subject);
        assert (cluster != null);
        if (cluster.getImmutable() && (this.session.serviceMode & 1) == 0 && subject != this.queryProcessor.getRootLibrary()) {
            throw new ImmutableException("Trying to modify immutable resource key=" + subject);
        }
        try {
            cluster.denyRelation(subject, predicate, object, (ClusterSupport)this.session.clusterTranslator);
        }
        catch (DatabaseException e) {
            LOGGER.error("removeStatement({}, {}, {}) failed", new Object[]{subject, predicate, object, e});
            return false;
        }
        this.queryProcessor.updateStatements(subject, predicate);
        return true;
    }
}

