/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.BuiltinData;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContextI;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.simantics.db.ClusterCreator;
import org.simantics.db.Database;
import org.simantics.db.SessionReference;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.support.VirtualGraphServerSupport;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.service.ClusterUID;

class GraphSessionVirtual
extends GraphSession {
    private static String FileName = "virtualGraph.builtins.dat";
    private static long BuiltinClusterId = -1L;
    private AtomicLong changeSetId = new AtomicLong(0L);
    private AtomicLong transactionId = new AtomicLong(0L);
    public static ServerInformationImpl serverInfo = new ServerInformationImpl("serverId", "protocolId", "databaseId", 0L);
    private VirtualGraphServerSupport virtualGraphServerSupport;

    public GraphSessionVirtual(SessionImplSocket sessionImpl, SessionReference sessionReference, VirtualGraphServerSupport vgss) {
        super(sessionImpl, sessionReference, new VirtualSession());
        this.virtualGraphServerSupport = vgss;
    }

    protected THashMap<String, BuiltinData> initBuiltinMap() throws DatabaseException {
        try {
            Properties props = new Properties();
            File from = new File(FileName);
            FileInputStream in = new FileInputStream(from);
            props.load(in);
            THashMap builtins = new THashMap();
            Set<String> keys = props.stringPropertyNames();
            for (String key : keys) {
                long resourceId = Long.parseLong(key);
                long cluster = BuiltinClusterId;
                int resourceIndex = (int)resourceId;
                String uri = props.getProperty(key);
                BuiltinData bd = new BuiltinData(resourceIndex, cluster);
                builtins.put((Object)uri, (Object)bd);
            }
            return builtins;
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to read builtins.", (Throwable)e);
        }
    }

    @Override
    protected ServerInformationImpl getServerInformation() {
        return serverInfo;
    }

    @Override
    public void acceptCommit(long transactionId, long csid, byte[] metadata) throws DatabaseException {
        this.changeSetId.incrementAndGet();
    }

    @Override
    public void cancelCommit(long transactionId, long csid, byte[] metadata, SynchronizeContextI context) throws DatabaseException {
        this.changeSetId.incrementAndGet();
    }

    @Override
    public void endTransaction(long transactionId, boolean write) throws DatabaseException {
    }

    @Override
    public long askWriteTransaction(int thread, long transactionId) throws DatabaseException {
        if (0L != transactionId) {
            return transactionId;
        }
        return this.transactionId.incrementAndGet();
    }

    @Override
    public long askReadTransaction(int thread) throws DatabaseException {
        return this.transactionId.incrementAndGet();
    }

    @Override
    public void stop() throws DatabaseException {
    }

    @Override
    public long reserveIds(int count) throws DatabaseException {
        long id = 0L;
        int i = 0;
        while (i < count) {
            id = this.virtualGraphServerSupport.createVirtual();
            ++i;
        }
        return id;
    }

    static class VirtualSession
    implements Database.Session {
        VirtualSession() {
        }

        public Database getDatabase() {
            return null;
        }

        public void close() throws ProCoreException {
        }

        public void open() throws ProCoreException {
        }

        public boolean isClosed() throws ProCoreException {
            return false;
        }

        public String execute(String command) throws ProCoreException {
            return null;
        }

        public void acceptCommit(long transactionId, long changeSetId, byte[] metadata) throws ProCoreException {
        }

        public long cancelCommit(long transactionId, long changeSetId, byte[] metadata, Database.Session.OnChangeSetUpdate on) throws ProCoreException {
            return 0L;
        }

        public Database.Session.Transaction askReadTransaction() throws ProCoreException {
            return null;
        }

        public Database.Session.Transaction askWriteTransaction(long transactionId) throws ProCoreException {
            return null;
        }

        public long endTransaction(long transactionId) throws ProCoreException {
            return 0L;
        }

        public byte[] getChangeSetMetadata(long changeSetId) throws ProCoreException {
            return null;
        }

        public Database.Session.ChangeSetData getChangeSetData(long minChangeSetId, long maxChangeSetId, Database.Session.OnChangeSetUpdate on) throws ProCoreException {
            return null;
        }

        public Database.Session.ChangeSetIds getChangeSetIds() throws ProCoreException {
            return null;
        }

        public Database.Session.Cluster getCluster(byte[] clusterId) throws ProCoreException {
            return null;
        }

        public Database.Session.ClusterChanges getClusterChanges(long changeSetId, byte[] clusterId) throws ProCoreException {
            return null;
        }

        public Database.Session.ClusterIds getClusterIds() throws ProCoreException {
            return null;
        }

        public Database.Session.Information getInformation() throws ProCoreException {
            return null;
        }

        public Database.Session.Refresh getRefresh(long changeSetId) throws ProCoreException {
            return null;
        }

        public Database.Session.ResourceSegment getResourceSegment(byte[] clusterUID, int resourceIndex, long offset, short size) throws ProCoreException {
            return null;
        }

        public long reserveIds(int count) throws ProCoreException {
            return 0L;
        }

        public void updateCluster(byte[] operations) throws ProCoreException {
        }

        public boolean undo(long[] cChangeSetIds, Database.Session.OnChangeSetUpdate onChangeSetUpdate) throws ProCoreException {
            return false;
        }

        public <T> T clone(ClusterUID clusterUID, ClusterCreator clusterCreator) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public boolean refreshEnabled() {
            return false;
        }

        public boolean rolledback() {
            return false;
        }
    }
}

