/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.TransientGraph;
import org.simantics.db.procore.cluster.ClusterImpl;

public class ClusteringSupportImpl
extends org.simantics.db.impl.ClusteringSupportImpl {
    private final SessionImplSocket session;

    ClusteringSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public int maximumClusterSize() {
        return ClusterTable.CLUSTER_FILL_SIZE;
    }

    public long createCluster() {
        long id;
        try {
            id = this.session.graphSession.newClusterId();
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException("Failed to get new cluster id.", (Throwable)e);
        }
        this.session.clusterTable.makeCluster(id, this.session.writeOnly);
        return id;
    }

    public long getCluster(Resource r) {
        int id = this.session.querySupport.getId(r);
        if (id < 0) {
            return TransientGraph.getVirtualClusterKey((int)id);
        }
        return this.session.clusterTable.getClusterIdByResourceKeyNoThrow(id);
    }

    public int getNumberOfResources(long clusterId) throws DatabaseException {
        return this.session.clusterTable.getClusterByClusterId(clusterId).getNumberOfResources((ClusterSupport)this.session.clusterTranslator);
    }

    public Resource getResourceByKey(int resourceKey) throws ResourceNotFoundException {
        return this.session.getResourceByKey(resourceKey);
    }

    public Resource getResourceByIndexAndCluster(int resourceIndex, long clusterId) throws DatabaseException, ResourceNotFoundException {
        if (resourceIndex < 1) {
            throw new ResourceNotFoundException("Illegal resource index=" + resourceIndex + " cluster=" + clusterId);
        }
        ClusterImpl cluster = this.session.getClusterTable().getLoadOrThrow(clusterId);
        int n = cluster.getNumberOfResources(null);
        if (resourceIndex > n) {
            throw new ResourceNotFoundException("Illegal resource index=" + resourceIndex + " cluster=" + clusterId + " max index=" + n);
        }
        return this.session.getResource(resourceIndex, clusterId);
    }

    public Resource getClusterSetOfCluster(Resource r) throws DatabaseException {
        if (!r.isPersistent()) {
            return null;
        }
        ClusterImpl cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(((ResourceImpl)r).id));
        Long rid = this.session.clusterSetsSupport.getSet(cluster.getClusterId());
        if (rid == null || rid == 0L) {
            return null;
        }
        return this.session.resourceSerializer.getResource(rid);
    }

    public Resource getClusterSetOfCluster(long cluster) throws DatabaseException {
        Long rid = this.session.clusterSetsSupport.getSet(cluster);
        if (rid == null || rid == 0L) {
            return null;
        }
        return this.session.resourceSerializer.getResource(rid);
    }

    public boolean isClusterSet(Resource r) throws DatabaseException {
        return this.session.containsClusterSet(r);
    }

    public long clusterIdByResourceKey(int resourceKey) {
        return this.session.clusterTable.getClusterIdByResourceKeyNoThrow(resourceKey);
    }

    public long clusterIdByClusterKey(int clusterKey) {
        ClusterBase base = this.session.clusterTable.getClusterByClusterKey(clusterKey);
        return base.clusterId;
    }

    public int clusterKeyByClusterId(long clusterId) {
        return this.session.clusterTable.getClusterKeyByClusterUIDOrMakeProxy(0L, clusterId);
    }

    public boolean isImmutableClusterKey(int clusterKey) {
        return this.session.clusterTable.isImmutableClusterKey(clusterKey);
    }

    public boolean isImmutableClusterId(long clusterId) {
        return this.isImmutableClusterKey(this.clusterKeyByClusterId(clusterId));
    }
}

