/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterSets;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.Disposable;
import org.simantics.db.IO;
import org.simantics.db.service.ClusterSetsSupport;

public class ClusterSetsSupportImpl2
implements ClusterSetsSupport,
Disposable {
    private static final boolean DEBUG = false;
    private static final Map<String, ClusterSets> sClusterSets = new HashMap<String, ClusterSets>();
    private IO read;
    private IO write;
    private String databaseId = null;
    private ClusterSets clusterSets = null;

    public synchronized void connect(String databaseId) {
        assert (this.databaseId == null);
        this.databaseId = databaseId;
        this.clusterSets = sClusterSets.get(databaseId);
        int count = 1;
        if (this.clusterSets == null) {
            this.clusterSets = new ClusterSets(this.read, this.write, databaseId);
            sClusterSets.put(databaseId, this.clusterSets);
        } else {
            count = this.clusterSets.inc();
        }
        this.clusterSets.touch();
    }

    public synchronized void dispose() {
        if (this.clusterSets == null) {
            return;
        }
        this.clusterSets.dispose();
        if (this.clusterSets.dec() <= 0) {
            sClusterSets.remove(this.databaseId);
        }
        this.clusterSets = null;
    }

    public synchronized boolean containsKey(long resourceId) {
        return this.clusterSets.containsKey(resourceId);
    }

    public synchronized Long get(Long resourceId) {
        return this.clusterSets.get(resourceId);
    }

    public synchronized void setActiveCluster(long clusterSetResourceId, long clusterId) {
        this.clusterSets.setActiveCluster(clusterSetResourceId, clusterId);
    }

    public void setImmutability(long clusterSetResourceId, boolean immutable) {
        this.clusterSets.setImmutability(clusterSetResourceId, immutable);
    }

    public synchronized void save() throws IOException {
        this.clusterSets.save();
    }

    public synchronized Long getSet(long clusterId) {
        return this.clusterSets.getClusterSet(clusterId);
    }

    public void clear() {
        this.clusterSets.clear();
    }

    public void updateWriteIO(IO io) {
        this.write = io;
        if (this.clusterSets != null) {
            this.clusterSets.setWriteDirectory(io);
            this.clusterSets.touch();
        }
    }

    public void setReadIO(IO io) {
        this.read = io;
    }

    public void validate(long[] ids) {
        this.clusterSets.validate(ids);
    }
}

