/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.Serialization;
import gnu.trove.set.hash.TLongHashSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.IO;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSets {
    static final Logger LOGGER = LoggerFactory.getLogger(ClusterSets.class);
    private IO write;
    private HashMap<Long, Long> clusterSets;
    private HashMap<Long, Long> reverseMap;
    private HashSet<Long> immutable;
    private int refCount;
    private boolean modified;

    public void setWriteDirectory(IO write) {
        this.write = write;
    }

    public boolean tryLoad1(IO read) throws Exception {
        try {
            byte[] blobBytes = read.readBytes(0L, (int)read.length());
            ByteArrayInputStream bais = new ByteArrayInputStream(blobBytes);
            PersistentDataBlob blob = (PersistentDataBlob)Files.readFile((InputStream)bais, (Binding)PersistentDataBlob.BINDING);
            bais.close();
            this.clusterSets = blob.clusterSets;
            this.reverseMap = blob.reverseMap;
            this.immutable = new HashSet();
            this.modified = false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean tryLoad2(IO read) throws Exception {
        try {
            byte[] blobBytes = read.readBytes(0L, (int)read.length());
            ByteArrayInputStream bais = new ByteArrayInputStream(blobBytes);
            PersistentDataBlob2 blob = (PersistentDataBlob2)Files.readFile((InputStream)bais, (Binding)PersistentDataBlob2.BINDING);
            bais.close();
            this.clusterSets = blob.clusterSets;
            this.reverseMap = blob.reverseMap;
            this.immutable = blob.immutable;
            this.modified = false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void create(IO read) throws Exception {
        PersistentDataBlob2 blob = new PersistentDataBlob2();
        blob.clusterSets = new HashMap();
        blob.reverseMap = new HashMap();
        blob.immutable = new HashSet();
        this.doSave2(blob);
        this.clusterSets = blob.clusterSets;
        this.reverseMap = blob.reverseMap;
        this.immutable = blob.immutable;
    }

    public ClusterSets(IO read, IO write, String databaseId) {
        try {
            this.write = write;
            if (!this.tryLoad1(read) && !this.tryLoad2(read)) {
                this.create(read);
            }
        }
        catch (Exception e) {
            throw new RuntimeDatabaseException("Failed to create ClusterSets.", (Throwable)e);
        }
    }

    public synchronized int inc() {
        return ++this.refCount;
    }

    public synchronized int dec() {
        return --this.refCount;
    }

    public void dispose() {
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeDatabaseException("Failed to save ClusterSets.");
        }
    }

    public synchronized boolean containsKey(long resourceId) {
        return this.clusterSets.containsKey(resourceId);
    }

    public synchronized Long get(Long resourceId) {
        return this.clusterSets.get(resourceId);
    }

    public synchronized void setActiveCluster(long clusterSetResourceId, long clusterId) {
        this.clusterSets.put(clusterSetResourceId, clusterId);
        this.reverseMap.put(clusterId, clusterSetResourceId);
        this.modified = true;
    }

    public synchronized void setImmutability(long clusterSetResourceId, boolean value) {
        this.modified = value ? (this.modified |= this.immutable.add(clusterSetResourceId)) : (this.modified |= this.immutable.remove(clusterSetResourceId));
    }

    public synchronized Long getClusterSet(Long clusterId) {
        return this.reverseMap.get(clusterId);
    }

    public void clear() {
        for (Long key : this.clusterSets.keySet()) {
            this.clusterSets.put(key, -1L);
        }
        this.touch();
    }

    public synchronized void touch() {
        this.modified = true;
    }

    private synchronized PersistentDataBlob2 doSave2(PersistentDataBlob2 blob) throws IOException {
        byte[] bytes = blob.bytes();
        this.write.saveBytes(bytes, bytes.length, true);
        this.modified = false;
        return blob;
    }

    public synchronized void save() throws IOException {
        if (!this.modified) {
            return;
        }
        PersistentDataBlob2 blob = new PersistentDataBlob2();
        blob.clusterSets = this.clusterSets;
        blob.reverseMap = this.reverseMap;
        blob.immutable = this.immutable;
        this.doSave2(blob);
    }

    public void validate(long[] ids) {
        TLongHashSet idSet = new TLongHashSet(ids);
        ArrayList<Long> clusterSetResourceIds = new ArrayList<Long>(this.clusterSets.keySet());
        for (long setResourceId : clusterSetResourceIds) {
            long setClusterId = ClusterTraitsBase.getClusterIdFromResourceId((long)setResourceId);
            if (!idSet.contains(setClusterId)) {
                this.clusterSets.remove(setResourceId);
                LOGGER.info("Remove cluster set mapping: cluster set has been removed " + setResourceId);
                continue;
            }
            long clusterId = this.clusterSets.get(setResourceId);
            if (clusterId == -1L || idSet.contains(clusterId)) continue;
            this.clusterSets.put(setResourceId, -1L);
            LOGGER.info("Reset cluster set mapping: active cluster set cluster has been removed " + setResourceId + " " + clusterId);
        }
        ArrayList<Long> setClusterIds = new ArrayList<Long>(this.reverseMap.keySet());
        for (Long clusterId : setClusterIds) {
            if (clusterId == -1L) continue;
            if (!idSet.contains(clusterId.longValue())) {
                this.reverseMap.remove(clusterId);
                LOGGER.info("Remove cluster set reverse mapping: cluster has been removed " + String.valueOf(clusterId));
                continue;
            }
            Long setResourceId = this.reverseMap.get(clusterId);
            long setClusterId = ClusterTraitsBase.getClusterIdFromResourceId((long)setResourceId);
            if (idSet.contains(setClusterId)) continue;
            this.reverseMap.remove(clusterId);
            LOGGER.info("Remove cluster set reverse mapping: cluster set cluster has been removed " + setClusterId);
        }
    }

    public static class PersistentDataBlob {
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentDataBlob.class);
        public HashMap<Long, Long> clusterSets;
        public HashMap<Long, Long> reverseMap;

        public byte[] bytes() throws IOException {
            return Serialization.toByteArray(4096, BINDING, this);
        }
    }

    public static class PersistentDataBlob2 {
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentDataBlob2.class);
        public HashMap<Long, Long> clusterSets;
        public HashMap<Long, Long> reverseMap;
        public HashSet<Long> immutable;

        public byte[] bytes() throws IOException {
            return Serialization.toByteArray(4096, BINDING, this);
        }
    }
}

