/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.impl.PrimeFinder;

public class LongHash {
    static final int HeaderSize = 2;
    private static final int UsedAndRealSize = -2;
    private static final int MaxAndFreeSize = -1;
    private static final int MinRealSize = 3;
    private static final int MinRealSizeMinusOne = 2;
    private static final long FREE = 0L;
    private static final long REMOVED = -1L;

    static final boolean isFree(long a) {
        return 0L == a;
    }

    static final boolean isFull(long a) {
        return a > 0L;
    }

    static final boolean isRemoved(long a) {
        return -1L == a;
    }

    static final long setFree() {
        return 0L;
    }

    static final long setFull(long a) {
        return a;
    }

    static final long setRemoved() {
        return -1L;
    }

    public static int getRealSize(long[] longs, int hashBase) {
        long desc = longs[hashBase + -2];
        assert (desc < 0L);
        int realSize = (int)desc & Integer.MAX_VALUE;
        assert (realSize > 2);
        return realSize;
    }

    private static void setUsedAndRealSize(long[] longs, int hashBase, int usedSize, int realSize) {
        assert (usedSize >= 0);
        assert (realSize > 2);
        int index = hashBase + -2;
        long desc = longs[index];
        assert (desc <= 0L);
        longs[index] = desc = (long)usedSize << 32 | (long)realSize | 0x8000000080000000L;
    }

    public static int getUsedSize(long[] longs, int hashBase) {
        long desc = longs[hashBase + -2];
        assert (desc < 0L);
        assert ((int)desc < 0);
        return (int)(desc >> 32) & Integer.MAX_VALUE;
    }

    static void setUsedSize(long[] longs, int hashBase, int usedSize) {
        assert (usedSize >= 0);
        int index = hashBase + -2;
        long desc = longs[index];
        assert (desc < 0L);
        assert ((int)desc < 0);
        longs[index] = desc = desc & 0x80000000FFFFFFFFL | (long)usedSize << 32;
    }

    static int decUsedSize(long[] longs, int hashBase) {
        int index = hashBase + -2;
        long desc = longs[index];
        assert (desc < 0L);
        int usedSize = ((int)(desc >> 32) & Integer.MAX_VALUE) - 1;
        assert (usedSize >= 0);
        longs[index] = desc = desc & 0x80000000FFFFFFFFL | (long)usedSize << 32;
        return usedSize;
    }

    static int incUsedSize(long[] longs, int hashBase) {
        int index = hashBase + -2;
        long desc = longs[index];
        assert (desc < 0L);
        int usedSize = ((int)(desc >> 32) & Integer.MAX_VALUE) + 1;
        assert (usedSize > 0);
        longs[index] = desc = desc & 0x80000000FFFFFFFFL | (long)usedSize << 32;
        return usedSize;
    }

    static int getFreeSize(long[] longs, int hashBase) {
        long desc = longs[hashBase + -1];
        assert (desc > 0L);
        int freeSize = (int)desc;
        assert (freeSize >= 0);
        return freeSize;
    }

    static void setFreeSize(long[] longs, int hashBase, int freeSize) {
        assert (freeSize >= 0);
        long desc = longs[hashBase + -1];
        assert (desc > 0L);
        assert ((int)desc >= 0);
        longs[hashBase + -1] = desc = desc & 0xFFFFFFFF00000000L | (long)freeSize;
    }

    static void decFreeSize(long[] longs, int hashBase) {
        long desc = longs[hashBase + -1];
        assert (desc > 0L);
        int freeSize = (int)desc;
        assert (freeSize > 0);
        longs[hashBase + -1] = desc = desc & 0xFFFFFFFF00000000L | (long)(--freeSize);
    }

    private static void setMaxAndFreeSize(long[] longs, int hashBase, int maxSize, int freeSize) {
        assert (maxSize > 0);
        assert (freeSize >= 0);
        int index = hashBase + -1;
        long desc = longs[index];
        assert (desc >= 0L);
        longs[index] = desc = (long)maxSize << 32 | (long)freeSize;
    }

    static int getMaxSize(long[] longs, int hashBase) {
        long desc = longs[hashBase + -1];
        assert (desc > 0L);
        assert ((int)desc >= 0);
        return (int)(desc >> 32);
    }

    static void setMaxSize(long[] longs, int hashBase, int maxSize) {
        assert (maxSize > 0);
        int index = hashBase + -1;
        long desc = longs[index];
        assert (desc > 0L);
        assert ((int)desc >= 0);
        longs[index] = desc = desc & 0xFFFFFFFFL | (long)maxSize << 32;
    }

    public static boolean add(AllocatorI allocator, long a) {
        int hashBase;
        long[] longs = allocator.getLongs();
        int index = LongHash.insertionIndex(longs, hashBase = allocator.getHashBase(), a);
        if (index < 0) {
            return false;
        }
        long previousState = longs[index];
        assert (LongHash.isFull(a));
        longs[index] = a;
        LongHash.postInsertHook(longs, hashBase, LongHash.isFree(previousState), allocator);
        return true;
    }

    public static boolean remove(long[] longs, int hashBase, long a) {
        int index = LongHash.index(longs, hashBase, a);
        if (index >= 0) {
            longs[index] = LongHash.setRemoved();
            LongHash.decUsedSize(longs, hashBase);
            return true;
        }
        return false;
    }

    public static boolean contains(long[] longs, int hashBase, long a) {
        return LongHash.index(longs, hashBase, a) >= 0;
    }

    public static boolean isEmpty(long[] longs, int hashBase) {
        return LongHash.getUsedSize(longs, hashBase) == 0;
    }

    public static void clear(long[] longs, int hashBase) {
        int capacity;
        long[] set = longs;
        long free = LongHash.setFree();
        int i = capacity = LongHash.getRealSize(longs, hashBase);
        while (i-- > 0) {
            set[hashBase + i] = free;
        }
        LongHash.setUsedSize(longs, hashBase, 0);
        LongHash.setFreeSize(longs, hashBase, capacity);
    }

    public static boolean ensureSize(AllocatorI allocator, int desiredSize) {
        long[] longs = allocator.getLongs();
        int hashBase = allocator.getHashBase();
        int size = LongHash.getUsedSize(longs, hashBase);
        if (desiredSize > LongHash.getMaxSize(longs, hashBase) - size) {
            int newCapacity = (desiredSize + size << 1) + 1;
            LongHash.rehash(longs, hashBase, PrimeFinder.nextPrime((int)newCapacity), allocator);
            return true;
        }
        return false;
    }

    public static void compact(AllocatorI allocator) {
        long[] longs = allocator.getLongs();
        int hashBase = allocator.getHashBase();
        LongHash.rehash(longs, hashBase, PrimeFinder.nextPrime((int)((LongHash.getUsedSize(longs, hashBase) << 1) + 1)), allocator);
    }

    public static int setUp(AllocatorI allocator, int initialCapacity) {
        int capacity = PrimeFinder.nextPrime((int)(initialCapacity << 1));
        int hashBase = allocator.allocate(capacity);
        assert (hashBase == allocator.getHashBase());
        long[] longs = allocator.getLongs();
        LongHash.setUsedAndRealSize(longs, hashBase, 0, capacity);
        LongHash.setMaxAndFreeSize(longs, hashBase, capacity >> 1, capacity);
        return hashBase;
    }

    static final void rehash(long[] oldLongs, int oldHashBase, int newCapacity, AllocatorI allocator) {
        assert (PrimeFinder.nextPrime((int)newCapacity) == newCapacity);
        int oldCapacity = LongHash.getRealSize(oldLongs, oldHashBase);
        int oldSize = LongHash.getUsedSize(oldLongs, oldHashBase);
        int newHashBase = allocator.allocate(newCapacity);
        long[] newLongs = allocator.getLongs();
        LongHash.setUsedAndRealSize(newLongs, newHashBase, oldSize, newCapacity);
        LongHash.setMaxAndFreeSize(newLongs, newHashBase, newCapacity >> 1, newCapacity - oldSize);
        int i = oldCapacity + oldHashBase;
        while (i-- > oldHashBase) {
            long o = oldLongs[i];
            if (!LongHash.isFull(o)) continue;
            int index = LongHash.insertionIndex(newLongs, newHashBase, o);
            newLongs[index] = o;
        }
    }

    protected static final void postInsertHook(long[] longs, int hashBase, boolean usedFreeSlot, AllocatorI allocator) {
        if (usedFreeSlot) {
            LongHash.decFreeSize(longs, hashBase);
        }
        if (LongHash.incUsedSize(longs, hashBase) > LongHash.getMaxSize(longs, hashBase) || LongHash.getFreeSize(longs, hashBase) == 0) {
            int newCapacity = LongHash.getUsedSize(longs, hashBase) > LongHash.getMaxSize(longs, hashBase) ? PrimeFinder.nextPrime((int)(LongHash.getRealSize(longs, hashBase) << 1)) : LongHash.getRealSize(longs, hashBase);
            LongHash.rehash(longs, hashBase, newCapacity, allocator);
        }
    }

    static int index(long[] longs, int hashBase, long a) {
        long[] set = longs;
        int length = LongHash.getRealSize(longs, hashBase);
        int hash = LongHash.computeHashCode(a);
        int index = hash % length;
        int hashIndex = hashBase + index;
        if (!LongHash.isFree(set[hashIndex]) && (LongHash.isRemoved(set[hashIndex]) || set[hashIndex] != a)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!LongHash.isFree(set[hashIndex = hashBase + index]) && (LongHash.isRemoved(set[hashIndex]) || set[hashIndex] != a));
        }
        return LongHash.isFree(set[hashIndex]) ? -1 : hashIndex;
    }

    static final int insertionIndex(long[] longs, int hashBase, long a) {
        long[] set = longs;
        int length = LongHash.getRealSize(longs, hashBase);
        int hash = LongHash.computeHashCode(a);
        int index = hash % length;
        assert (hashBase != 0);
        int hashIndex = hashBase + index;
        if (LongHash.isFree(set[hashIndex])) {
            return hashIndex;
        }
        if (LongHash.isFull(set[hashIndex]) && set[hashIndex] == a) {
            return -hashIndex;
        }
        int probe = 1 + hash % (length - 2);
        if (!LongHash.isRemoved(set[hashIndex])) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (LongHash.isFull(set[hashIndex = hashBase + index]) && set[hashIndex] != a);
        }
        if (LongHash.isRemoved(set[hashIndex])) {
            int firstRemoved = hashIndex;
            while (!LongHash.isFree(set[hashIndex]) && (LongHash.isRemoved(set[hashIndex]) || set[hashIndex] != a)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                hashIndex = hashBase + index;
            }
            return LongHash.isFull(set[hashIndex]) ? -hashIndex : firstRemoved;
        }
        return LongHash.isFull(set[hashIndex]) ? -hashIndex : hashIndex;
    }

    static final int computeHashCode(long aKey) {
        int hash = (int)(aKey ^ aKey >> 32) * 31;
        return hash & Integer.MAX_VALUE;
    }

    static interface AllocatorI {
        public int allocate(int var1);

        public long[] getLongs();

        public int getHashBase();
    }
}

