/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.util.Arrays;
import org.simantics.db.procore.cluster.Allocator;

class IntAllocator
extends Allocator {
    int[] backup = null;
    int[] memory;
    static final int ResourceHash = 0;
    static final int ObjectHash = 1;
    static final int HeaderSize = 2;

    IntAllocator releaseMemory() {
        this.backup = null;
        this.memory = null;
        return null;
    }

    int getResourceHash() {
        if (this.memory == null) {
            return 0;
        }
        return this.memory[0];
    }

    int getObjectHash() {
        if (this.memory == null) {
            return 0;
        }
        return this.memory[1];
    }

    void setResourceHash(int a) {
        this.memory[0] = a;
    }

    void setObjectHash(int a) {
        this.memory[1] = a;
    }

    IntAllocator(int[] ints, int size) {
        this.memory = ints;
        this.setSize(size);
    }

    int[] getBackup() {
        return this.backup;
    }

    int[] getMemory() {
        return this.memory;
    }

    @Override
    int getCapacity() {
        if (this.memory == null) {
            return 0;
        }
        return this.memory.length;
    }

    @Override
    void resizeMemory(int capacity) {
        assert (capacity >= 2);
        assert (this.backup == null);
        this.memory = Arrays.copyOf(this.memory, capacity);
    }

    @Override
    void backupResize(int capacity, int size, int copySize) {
        assert (capacity >= 2);
        assert (capacity >= copySize);
        assert (capacity >= size);
        if (size < 0) {
            size = this.getSize();
        } else if (size < 2) {
            size = 2;
        }
        assert (size <= capacity);
        if (copySize < 0) {
            copySize = size;
        }
        assert (copySize <= size);
        assert (copySize <= this.getSize());
        assert (this.backup == null);
        this.backup = this.memory;
        this.memory = new int[capacity];
        this.setSize(size);
        System.arraycopy(this.backup, 0, this.memory, 0, copySize);
    }

    @Override
    void backupFree() {
        this.backup = null;
    }

    void dump() {
        int i = 0;
        while (i < this.getSize()) {
            System.out.println("ints[" + i + "]=" + this.memory[i]);
            ++i;
        }
        System.out.println("ints capacity=" + this.memory.length);
    }
}

