/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.util.Vector;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.procore.cluster.CCSParser;
import org.simantics.db.procore.cluster.ClusterChangeSetI;
import org.simantics.db.procore.cluster.FastLZ;
import org.simantics.db.procore.cluster.LZ4;
import org.simantics.db.service.ClusterUID;

public class ClusterChangeSet
implements ClusterChangeSetI {
    private static final boolean DEBUG = false;
    private static final int HEADER_SIZE = 20;
    private final int version;
    private final ClusterUID clusterUID;
    private final byte[] bytes;
    private Blocks mBlocks = new Blocks();

    public static ClusterChangeSetI create(byte[] rawData, String compressionCodec) throws InternalException {
        byte[] bytes;
        if (compressionCodec.equals("LZ4")) {
            LZ4.DecompressStruct data = LZ4.decompress(rawData);
            bytes = data.bytes;
        } else if (compressionCodec.equals("FLZ")) {
            FastLZ.DecompressStruct data = FastLZ.decompress(rawData);
            bytes = data.bytes;
        } else {
            throw new RuntimeDatabaseException("No compressionCodec given!");
        }
        return new ClusterChangeSet(bytes);
    }

    public String toString() {
        return "cid=" + String.valueOf(this.clusterUID) + " len=" + this.bytes.length;
    }

    /*
     * Unable to fully structure code
     */
    private ClusterChangeSet(byte[] abytes) {
        super();
        this.bytes = abytes;
        if (this.bytes.length < 24) {
            throw new RuntimeDatabaseException("Cluster change must contain header and size. length=" + this.bytes.length);
        }
        this.version = CCSParser.getInt(this.bytes, 0);
        if (this.version < 1 || this.version > 2) {
            throw new RuntimeDatabaseException("Unsupported cluster change set version=" + this.version);
        }
        this.clusterUID = ClusterUID.make((byte[])abytes, (int)4);
        if (ClusterUID.Null.equals((Object)this.clusterUID)) {
            throw new RuntimeDatabaseException("Cluster uid can not be null.");
        }
        p = 20;
        size = CCSParser.getInt(this.bytes, p);
        if (2 != this.version) ** GOTO lbl19
        System.out.println("Cluster change set version=2 is not supported. skipping...");
        return;
lbl-1000:
        // 1 sources

        {
            this.mBlocks.push_back(new ClusterChangeSetBlock(p += 4, size, this.bytes));
            size = CCSParser.getInt(this.bytes, p += size);
lbl19:
            // 2 sources

            ** while (size > 0)
        }
lbl20:
        // 1 sources

    }

    @Override
    public ClusterUID getClusterUID() {
        return this.clusterUID;
    }

    private boolean updateRequired() {
        return false;
    }

    private void update() {
    }

    @Override
    public void getNextOperation(ClusterChangeSetI.Operation ar) {
        Iterator pIterator = null;
        if (ar.iterator == null) {
            int N;
            if (this.updateRequired()) {
                this.update();
            }
            if ((N = this.mBlocks.size()) == 0) {
                ar.type = ClusterChangeSetI.OperationEnum.EndOf;
                return;
            }
            pIterator = new Iterator(N - 1);
            ar.iterator = pIterator;
        } else {
            pIterator = (Iterator)ar.iterator;
        }
        if (pIterator.block > pIterator.lastBlock) {
            ar.type = ClusterChangeSetI.OperationEnum.EndOf;
            ar.iterator = null;
            return;
        }
        if (pIterator.offset >= this.mBlocks.get((int)pIterator.block).size) {
            ++pIterator.block;
            pIterator.foreignTable.init();
            pIterator.offset = 0;
            if (pIterator.block > pIterator.lastBlock) {
                ar.type = ClusterChangeSetI.OperationEnum.EndOf;
                ar.iterator = null;
                return;
            }
        }
        if (pIterator.offset >= this.mBlocks.get((int)pIterator.block).size) {
            ++pIterator.block;
            pIterator.foreignTable.init();
            pIterator.offset = 0;
            if (pIterator.block > pIterator.lastBlock) {
                ar.type = ClusterChangeSetI.OperationEnum.EndOf;
                ar.iterator = null;
                return;
            }
        }
        ClusterChangeSetBlock r = this.mBlocks.get(pIterator.block);
        int inc = this.next(ar, pIterator, r.bytes, r.offset + pIterator.offset, r.offset + r.size);
        if (inc <= 0) {
            if (inc < 0) {
                System.out.println("Iterarto offset increment is negative!");
            }
            ar.type = ClusterChangeSetI.OperationEnum.EndOf;
            ar.iterator = null;
        } else {
            pIterator.offset += inc;
        }
    }

    private int next(ClusterChangeSetI.Operation ar, Iterator pIterator, byte[] bytes, int ab, int ae) {
        CCSParser.Args args = new CCSParser.Args(this.clusterUID, pIterator.foreignTable, ar);
        int pb = ab;
        int p = pb;
        int pe = ae;
        if (p < pe) {
            short ri = 0;
            short kraa = (short)(bytes[p] & 0xFF);
            switch (kraa) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 2, CCSParser.ReferenceType.Local, CCSParser.ReferenceType.Local);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 2, CCSParser.ReferenceType.Local, CCSParser.ReferenceType.Local);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 2, CCSParser.ReferenceType.Local, CCSParser.ReferenceType.ForeignLong);
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 2, CCSParser.ReferenceType.Local, CCSParser.ReferenceType.ForeignLong);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 2, CCSParser.ReferenceType.ForeignLong, CCSParser.ReferenceType.Local);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 2, CCSParser.ReferenceType.ForeignLong, CCSParser.ReferenceType.Local);
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 2, CCSParser.ReferenceType.ForeignLong, CCSParser.ReferenceType.ForeignLong);
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 2, CCSParser.ReferenceType.ForeignLong, CCSParser.ReferenceType.ForeignLong);
                    break;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 4, CCSParser.ReferenceType.ForeignShort, CCSParser.ReferenceType.Local);
                    break;
                }
                case 49: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 0, CCSParser.ReferenceType.Local, CCSParser.ReferenceType.ForeignShort);
                    break;
                }
                case 50: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 0, CCSParser.ReferenceType.ForeignShort, CCSParser.ReferenceType.ForeignLong);
                    break;
                }
                case 51: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 0, CCSParser.ReferenceType.ForeignLong, CCSParser.ReferenceType.ForeignShort);
                    break;
                }
                case 52: {
                    ri = CCSParser.getShort(bytes, p + 1);
                    args.createResource(ri);
                    p += 3;
                    break;
                }
                case 53: {
                    int t = CCSParser.getInt(bytes, p + 1);
                    ri = (short)(t & 0x3FFF);
                    int s = t >>> 14;
                    args.setValue(ri, bytes, p + 5, s);
                    p += 5 + s;
                    break;
                }
                case 54: {
                    ri = CCSParser.getShort(bytes, p + 1);
                    args.deleteValue(ri);
                    p += 3;
                    break;
                }
                case 55: {
                    ri = CCSParser.getShort(bytes, p + 1);
                    ri = (short)(ri & 0x3FFF);
                    long vo = CCSParser.getLongN(bytes, p + 3, 7);
                    vo |= (long)(bytes[p + 2] & 0xC0) << 50;
                    int vsize = CCSParser.getShort(bytes, p += 10);
                    if (vsize < 0) {
                        vsize += 65536;
                    }
                    if (pe - (p += 2) < vsize) {
                        throw new RuntimeException("Illegal size=" + vsize + " limit=" + (pe - p));
                    }
                    args.modifyValue(ri, vo, vsize, bytes, p);
                    p += vsize;
                    break;
                }
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    byte s = (byte)(bytes[p] & 7);
                    s = (byte)(s << 2);
                    ri = CCSParser.getShort(bytes, p + 1);
                    ri = (short)(ri & 0x3FFF);
                    byte t = bytes[p + 2];
                    s = (byte)(s | (t & 0xFF) >> 6);
                    args.setValue(ri, bytes, p + 3, s);
                    p += 3 + s;
                    break;
                }
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 6, CCSParser.ReferenceType.ForeignShort, CCSParser.ReferenceType.ForeignShort);
                    break;
                }
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Remove, args, bytes, p, 6, CCSParser.ReferenceType.ForeignShort, CCSParser.ReferenceType.ForeignShort);
                    break;
                }
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 4, CCSParser.ReferenceType.Local, CCSParser.ReferenceType.ForeignShort);
                    break;
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 4, CCSParser.ReferenceType.ForeignShort, CCSParser.ReferenceType.Local);
                    break;
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 4, CCSParser.ReferenceType.ForeignShort, CCSParser.ReferenceType.ForeignLong);
                    break;
                }
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    p = CCSParser.parseStm(CCSParser.StmEnum.Add, args, bytes, p, 4, CCSParser.ReferenceType.ForeignLong, CCSParser.ReferenceType.ForeignShort);
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error in cluster stream (v=" + kraa + ")");
                }
            }
        }
        return p - pb;
    }

    private static class Blocks {
        private static final int BLOCK_INCREMENT = 10;
        private Vector<ClusterChangeSetBlock> mBlocks = new Vector();

        Blocks() {
            this.mBlocks.ensureCapacity(10);
        }

        int size() {
            return this.mBlocks.size();
        }

        void push_back(ClusterChangeSetBlock ar) {
            if (this.mBlocks.size() == this.mBlocks.capacity()) {
                this.mBlocks.ensureCapacity(this.mBlocks.size() + 10);
            }
            this.mBlocks.add(ar);
        }

        ClusterChangeSetBlock get(int i) {
            return this.mBlocks.get(i);
        }
    }

    private static class ClusterChangeSetBlock {
        byte[] bytes;
        int offset;
        int size;

        ClusterChangeSetBlock(int offset, int size, byte[] bytes) {
            this.bytes = bytes;
            this.offset = offset;
            this.size = size;
        }
    }

    private static class Iterator
    implements IteratorI {
        int lastBlock;
        int block;
        int offset;
        CCSParser.ForeignTable foreignTable;

        Iterator(int lastBlock) {
            this.lastBlock = lastBlock;
            this.foreignTable = new CCSParser.ForeignTable();
        }
    }

    static interface IteratorI {
    }
}

