/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.procore.cluster.AllocationException;

abstract class Allocator {
    static final int MaxIncrement = 1000000;
    static final int MinIncrement = 100;
    private int size;

    Allocator() {
    }

    abstract int getCapacity();

    abstract void resizeMemory(int var1);

    abstract void backupResize(int var1, int var2, int var3);

    abstract void backupFree();

    int getSize() {
        return this.size;
    }

    void setSize(int size) {
        assert (size > 0 && size <= this.getCapacity());
        this.size = size;
    }

    int newElement(int size) {
        int oldSize = this.size;
        int newSize = oldSize + size;
        if (newSize > this.getCapacity()) {
            throw new AllocationException(this, size);
        }
        this.size = newSize;
        return oldSize;
    }

    void ensureSpace(int esize) {
        int increment;
        int space = this.getCapacity() - this.size;
        int n = increment = space > 0 && esize > 0 ? esize - space : 100;
        if (increment <= 0) {
            return;
        }
        increment = Math.max(increment, 100);
        int defaultCapacity = Math.min(this.getCapacity() << 1, this.getCapacity() + 1000000);
        int newCapacity = Math.max(defaultCapacity, this.getCapacity() + increment);
        this.resizeMemory(newCapacity);
    }
}

