/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.Change;
import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.IOException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ClusterBuilder;
import org.simantics.db.service.SerialisationSupport;

public final class ResourceHandleImpl
implements ClusterBuilder.ResourceHandle {
    private final ClusterImpl cluster;
    public final int resourceKey;

    public ResourceHandleImpl(SessionImplSocket.WriteOnlySupport support) throws DatabaseException {
        this.resourceKey = support.createResourceKey(1);
        this.cluster = support.currentCluster;
        if (this.cluster.cc == null) {
            this.cluster.cc = new ClusterChange(support.stream, this.cluster);
        }
    }

    public ResourceHandleImpl(ClusterStream stream, ClusterImpl cluster, int resourceKey) {
        this.resourceKey = resourceKey;
        this.cluster = cluster;
        if (cluster.cc == null) {
            cluster.cc = new ClusterChange(stream, cluster);
        }
    }

    public void applyPredicate(Object cluster) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        impl.change.addStatementIndex1(this.resourceKey, this.cluster.clusterUID, (byte)0, impl.foreignLookup);
    }

    public void applyObject(Object cluster) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        impl.change.addStatementIndex2(this.resourceKey, this.cluster.clusterUID, (byte)0, impl.foreignLookup);
    }

    public void addStatement(ClusterBuilder.StatementHandle handle) {
        if (this.cluster.getImmutable()) {
            return;
        }
        this.cluster.change.addStatementIndex0(this.resourceKey, (byte)2);
        handle.apply((Object)this.cluster);
        this.cluster.cc.addChange(this.cluster.change);
    }

    public void addStatement(ClusterBuilder.ResourceHandle predicate, ClusterBuilder.ResourceHandle object) {
        if (this.cluster.getImmutable()) {
            return;
        }
        Change change = this.cluster.change;
        change.addStatementIndex0(this.resourceKey, (byte)2);
        predicate.applyPredicate((Object)this.cluster);
        object.applyObject((Object)this.cluster);
        this.cluster.cc.addChange(change);
    }

    public void addStatement(WriteOnlyGraph graph, ClusterBuilder.ResourceHandle predicate, ClusterBuilder.ResourceHandle object) throws DatabaseException {
        if (this.cluster.isWriteOnly()) {
            this.addStatement(predicate, object);
        } else {
            WriteGraphImpl impl = (WriteGraphImpl)graph;
            impl.writeSupport.claim(graph.getProvider(), this.resourceKey, ((ResourceHandleImpl)predicate).resourceKey, ((ResourceHandleImpl)object).resourceKey);
        }
    }

    public void addValue(WriteOnlyGraph graph, byte[] bytes) throws DatabaseException {
        if (this.cluster.isWriteOnly()) {
            this.cluster.cc.setValue((short)(this.resourceKey & 0xFFFF), bytes);
        } else {
            WriteGraphImpl impl = (WriteGraphImpl)graph;
            impl.writeSupport.claimValue(null, this.resourceKey, bytes, bytes.length);
        }
    }

    public void addValue(Object value, Binding binding) {
        try {
            Serializer ser = Bindings.getSerializerUnchecked((Binding)binding);
            byte[] bytes = ser.serialize(value);
            this.cluster.cc.setValue((short)(this.resourceKey & 0xFFFF), bytes);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addValue(Object value, Serializer serializer) {
        try {
            byte[] bytes = serializer.serialize(value);
            this.cluster.cc.setValue((short)(this.resourceKey & 0xFFFF), bytes);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Resource resource(SerialisationSupport ss) {
        try {
            return ss.getResource(this.resourceKey);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }
}

