/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.Resource;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.support.ResourceSupport;

final class ObjectResourceMap<T>
implements Map<T, Resource>,
ObjectResourceIdMap<T> {
    private final SessionImplSocket session;
    private final TObjectIntHashMap<T> backend;

    ObjectResourceMap(SessionImplSocket session) {
        this.session = session;
        this.backend = new TObjectIntHashMap(10, 0.5f, 0);
    }

    ObjectResourceMap(SessionImplSocket session, int capacity) {
        this.session = session;
        this.backend = new TObjectIntHashMap(capacity, 0.5f, 0);
    }

    @Override
    public int size() {
        return this.backend.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backend.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backend.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ResourceImpl impl = (ResourceImpl)value;
        return this.backend.containsValue(impl.id);
    }

    @Override
    public Resource get(Object key) {
        int result;
        block3: {
            try {
                result = this.backend.get(key);
                if (result != 0) break block3;
                return null;
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.session.getResourceByKey(result);
    }

    @Override
    public Resource put(T key, Resource value) {
        ResourceImpl impl = (ResourceImpl)value;
        int i = this.backend.put(key, impl.id);
        if (i == 0) {
            return null;
        }
        try {
            return this.session.getResourceByKey(i);
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Resource remove(Object key) {
        throw new UnsupportedOperationException("remove not supported, structure is immutable");
    }

    @Override
    public void putAll(Map<? extends T, ? extends Resource> map) {
        ObjectResourceMap other = (ObjectResourceMap)map;
        other.backend.forEachEntry(new TObjectIntProcedure<T>(){

            public boolean execute(T a, int b) {
                ObjectResourceMap.this.backend.put(a, b);
                return true;
            }
        });
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear not supported, structure is immutable");
    }

    @Override
    public Set<T> keySet() {
        final HashSet result = new HashSet();
        this.backend.forEach(new TObjectProcedure<T>(){

            public boolean execute(T object) {
                result.add(object);
                return true;
            }
        });
        return result;
    }

    @Override
    public Collection<Resource> values() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        int[] nArray = this.backend.values();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int key = nArray[n2];
            try {
                result.add(this.session.getResourceByKey(key));
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<T, Resource>> entrySet() {
        final HashSet<Map.Entry<T, Resource>> result = new HashSet<Map.Entry<T, Resource>>();
        this.backend.forEachEntry(new TObjectIntProcedure<T>(){

            public boolean execute(final T a, final int b) {
                return result.add(new Map.Entry<T, Resource>(){

                    @Override
                    public T getKey() {
                        return a;
                    }

                    @Override
                    public Resource getValue() {
                        return new ResourceImpl((ResourceSupport)(this).ObjectResourceMap.this.session.resourceSupport, b);
                    }

                    @Override
                    public Resource setValue(Resource value) {
                        throw new UnsupportedOperationException("Map.Entry.setValue not supported, structure is immutable");
                    }
                });
            }
        });
        return result;
    }

    @Override
    public int hashCode() {
        return this.backend.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            if (!(obj instanceof Map)) {
                return false;
            }
            Map m = (Map)obj;
            if (m.size() != this.size()) {
                return false;
            }
            try {
                T key;
                Map.Entry<T, Resource> e;
                Resource value;
                Iterator<Map.Entry<T, Resource>> i = this.entrySet().iterator();
                do {
                    if (!i.hasNext()) {
                        return true;
                    }
                    e = i.next();
                    key = e.getKey();
                } while (!((value = e.getValue()) == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))));
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        ObjectResourceMap other = (ObjectResourceMap)obj;
        return this.session == other.session && this.backend.equals(other.backend);
    }

    public void putId(T t, int r) {
        this.backend.put(t, r);
    }

    public int getId(T t) {
        return this.backend.get(t);
    }
}

