/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.BuiltinData;
import fi.vtt.simantics.procore.internal.ChangeSetIdentifierImpl;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.StatementImpl;
import fi.vtt.simantics.procore.internal.StatementImplOld;
import fi.vtt.simantics.procore.internal.SynchronizeContextI;
import fi.vtt.simantics.procore.internal.UpdateClusterFunction;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Database;
import org.simantics.db.Operation;
import org.simantics.db.SessionReference;
import org.simantics.db.common.UndoContextEx;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ExternalOperation;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.ValueStream;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.utils.threads.ThreadUtils;

public abstract class GraphSession {
    protected final boolean DEBUG = false;
    protected final boolean VERBOSE = false;
    protected Listener listener;
    protected SessionImplSocket session;
    protected final Database.Session dbSession;
    private SessionReference sessionReference;
    private TLongObjectHashMap<ClusterI> clusterMap = new TLongObjectHashMap();
    protected THashMap<String, BuiltinData> builtinMap = null;
    private long firstChangeSetId = 0L;
    protected SynchronizeContextI synchronizeContext;
    final UndoContextEx undoContext = new UndoContextEx("GraphSession");
    final CopyOnWriteArrayList<ManagementSupport.ChangeSetListener> changeSetListeners = new CopyOnWriteArrayList();
    private long lastChangeSetId = 0L;
    protected MetadataCache metadataCache = new MetadataCache();
    private HashSet<Long> loadedClusters = new HashSet();
    long total = 0L;
    long load = 0L;
    long inflate = 0L;

    public GraphSession(SessionImplSocket sessionImpl, SessionReference sessionReference, Database.Session dbSession) {
        this.dbSession = dbSession;
        if (dbSession == null) {
            throw new RuntimeException("Failed to initialize GraphSession. Database.Session can not be null.");
        }
        this.sessionReference = sessionReference;
        this.session = sessionImpl;
    }

    void addChangeSetListener(ManagementSupport.ChangeSetListener csl) {
        this.changeSetListeners.add(csl);
    }

    void removeChangeSetListener(ManagementSupport.ChangeSetListener csl) {
        this.changeSetListeners.remove(csl);
    }

    SessionReference getSessionReference() {
        return this.sessionReference;
    }

    public void open() throws InternalException {
        this.dbSession.open();
    }

    public void close() throws InternalException {
        this.dbSession.close();
    }

    public long getSessionId() {
        return this.sessionReference.getSessionId();
    }

    long getFirstChangeSetId() {
        return this.firstChangeSetId;
    }

    String getClusterFileName(long clusterId) {
        String fileName = "cluster" + clusterId + ".dat";
        return fileName;
    }

    int computeClusterMemoryUse() {
        int size = 0;
        TLongObjectIterator i = this.clusterMap.iterator();
        while (i.hasNext()) {
            i.advance();
            ClusterI c = (ClusterI)i.value();
            try {
                size = (int)((long)size + c.getUsedSpace());
            }
            catch (DatabaseException databaseException) {
                Logger.defaultLogInfo((String)("GetUsedSpace faile for cluster " + String.valueOf(c)));
            }
        }
        return size;
    }

    void printClusterSize() {
        long size = 0L;
        long amount = 0L;
        TLongObjectIterator i = this.clusterMap.iterator();
        while (i.hasNext()) {
            i.advance();
            ClusterI c = (ClusterI)i.value();
            if (!c.isLoaded()) continue;
            try {
                size += c.getUsedSpace();
            }
            catch (DatabaseException databaseException) {
                Logger.defaultLogInfo((String)("GetUsedSpace faile for cluster " + String.valueOf(c)));
            }
            ++amount;
        }
        if (amount > 50L) {
            this.loadedClusters.clear();
        }
        System.out.println(size / 0x100000L + "M in " + amount + " clusters.");
    }

    ClusterI freeClusterFromCacheAndFreeClusterMemory(long clusterId) {
        ClusterI c = (ClusterI)this.clusterMap.remove(clusterId);
        if (c != null) {
            c.releaseMemory();
        }
        return c;
    }

    private void debugPrint(UpdateClusterFunction f) {
        int i = 0;
        while (i < f.operation.length) {
            System.out.println("op=" + f.operation[i]);
            ++i;
        }
    }

    public boolean updateCluster(UpdateClusterFunction f) {
        this.session.clusterStream.markDirty();
        assert (f != null);
        try {
            this.dbSession.updateCluster(f.operation);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] getChangeSetContext(long id) throws DatabaseException {
        byte[] data = this.metadataCache.get(id);
        if (data != null) {
            return data;
        }
        if (id < this.getServerInformation().firstChangeSetId) {
            Logger.defaultLogInfo((String)("Asking purged change set metadata. uid=" + id));
            return new byte[0];
        }
        return this.dbSession.getChangeSetMetadata(id);
    }

    public StatementImpl getStatement(ResourceImpl s, ResourceImpl p, ResourceImpl o) {
        return new StatementImplOld(s, p, o);
    }

    public long newClusterId() throws DatabaseException {
        long id = this.dbSession.reserveIds(1);
        if (id <= ClusterUID.Builtin.second) {
            return this.newClusterId();
        }
        return id;
    }

    ClusterI getCluster(long clusterId) {
        return (ClusterI)this.clusterMap.get(clusterId);
    }

    ClusterI getClusterOrThrow(long clusterId) throws IllegalArgumentException {
        ClusterI c = this.getCluster(clusterId);
        if (c == null) {
            throw new IllegalArgumentException("Cluster " + clusterId + " does not exist.");
        }
        return c;
    }

    public String execute(String command) throws DatabaseException {
        return this.dbSession.execute(command);
    }

    public Collection<ChangeSetIdentifier> getChangeSets() throws DatabaseException {
        Database.Session.ChangeSetIds t = this.dbSession.getChangeSetIds();
        return ChangeSetIdentifierImpl.longs2changeSetIds(this, t.getFirstChangeSetId(), t.getCount());
    }

    public long getLastChangeSetId() {
        return this.lastChangeSetId;
    }

    public Collection<ChangeSetIdentifier> getChangeSets(long from, long to, long upperLimit) throws DatabaseException {
        if (from > to) {
            throw new DatabaseException("Illegal argument: from=" + from + " > to=" + to + ".");
        }
        long min = Math.max(from, 1L);
        long max = Math.min(to, upperLimit);
        return ChangeSetIdentifierImpl.longs2changeSetIds(this, min, max);
    }

    public boolean getChangeSets(long minCS, long maxCS, SynchronizeContextI context) throws DatabaseException {
        try {
            this.synchronizeContext = context;
            Database.Session.ChangeSetData t = this.dbSession.getChangeSetData(minCS, maxCS, (Database.Session.OnChangeSetUpdate)context);
            boolean bl = !t.isOk();
            return bl;
        }
        catch (Throwable e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException("GetChangeSetData call to server failed.");
        }
        finally {
            this.synchronizeContext = null;
        }
    }

    public static void forExternals(Collection<Operation> operations, Function1<ExternalOperation, Boolean> fn) {
        for (Operation o : operations) {
            for (ExternalOperation e : o.getExternalOperations()) {
                if (e.isDisposed()) continue;
                fn.apply((Object)e);
            }
        }
    }

    public boolean undo(Collection<Operation> changeSetIds, SynchronizeContextI context) throws DatabaseException {
        try {
            GraphSession.forExternals(changeSetIds, (Function1<ExternalOperation, Boolean>)new FunctionImpl1<ExternalOperation, Boolean>(){

                public Boolean apply(ExternalOperation op) {
                    op.undo();
                    return true;
                }
            });
            long[] cids = ChangeSetIdentifierImpl.operations2ints(changeSetIds);
            this.synchronizeContext = context;
            boolean bl = this.dbSession.undo(cids, (Database.Session.OnChangeSetUpdate)context);
            return bl;
        }
        catch (Throwable e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException("Undo call to server failed.", e);
        }
        finally {
            this.synchronizeContext = null;
        }
    }

    public ClusterUID[] getRefresh2(long csid) throws DatabaseException {
        Database.Session.Refresh t = this.dbSession.getRefresh(csid);
        ClusterUID[] clusters = new ClusterUID[t.getFirst().length];
        int i = 0;
        while (i < t.getFirst().length) {
            clusters[i] = new ClusterUID(t.getFirst()[i], t.getSecond()[i]);
            ++i;
        }
        return clusters;
    }

    public Database.Session.ClusterChanges getClusterChanges(ClusterUID cluster, long csid) throws DatabaseException {
        Database.Session.ClusterChanges t = this.dbSession.getClusterChanges(csid, cluster.asBytes());
        return t;
    }

    public long getCluster(int id) {
        return this.session.getCluster(id);
    }

    public ResourceSegment getResourceSegment(int resourceIndex, ClusterUID clusterUID, long offset, short size) throws DatabaseException {
        Database.Session.ResourceSegment t = this.dbSession.getResourceSegment(clusterUID.asBytes(), resourceIndex, offset, size);
        return new ResourceSegment(t.getValueSize(), t.getSegment());
    }

    public byte[] getResourceValue(int resourceIndex, ClusterUID clusterUID) throws DatabaseException {
        return this.getResourceValue(resourceIndex, clusterUID, 0L, 0);
    }

    public InputStream getResourceValueStream(final int resourceIndex, final ClusterUID clusterUID, long offset, int length) throws DatabaseException {
        long rSize;
        short slen = (short)Math.min(length != 0 ? length : 65535, 65535);
        ResourceSegment s = this.getResourceSegment(resourceIndex, clusterUID, offset, slen);
        if (s.valueSize < 0L) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + " (1).");
        }
        int ilen = slen & 0xFFFF;
        assert (s.bytes.length <= ilen);
        if (length == 0) {
            if (s.valueSize > Integer.MAX_VALUE) {
                throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (2).");
            }
            length = (int)s.valueSize;
        }
        if ((rSize = s.valueSize - offset) < (long)length) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (3).");
        }
        if (length <= 65535) {
            return new ValueStream(s.bytes);
        }
        int finalLength = length;
        InputStream is = new InputStream(finalLength, s){
            int left;
            long valueOffset;
            int offset;
            ResourceSegment _s;
            {
                this.left = n;
                this.valueOffset = 0L;
                this.offset = 0;
                this._s = resourceSegment;
            }

            @Override
            public int read() throws IOException {
                int result;
                if (this.left <= 0) {
                    return -1;
                }
                if (this.offset == this._s.bytes.length) {
                    short slen = (short)Math.min(this.left, 65535);
                    this.valueOffset += (long)this._s.bytes.length;
                    try {
                        this._s = GraphSession.this.getResourceSegment(resourceIndex, clusterUID, this.valueOffset, slen);
                    }
                    catch (DatabaseException e) {
                        throw new IOException(e);
                    }
                    this.offset = 0;
                }
                --this.left;
                if ((result = this._s.bytes[this.offset++]) < 0) {
                    result += 256;
                }
                return result;
            }
        };
        return new ValueStream(is, finalLength);
    }

    public byte[] getResourceValue(int resourceIndex, ClusterUID clusterUID, long offset, int length) throws DatabaseException {
        long rSize;
        short slen = (short)Math.min(length != 0 ? length : 65535, 65535);
        ResourceSegment s = this.getResourceSegment(resourceIndex, clusterUID, offset, slen);
        long VALUE_SIZE = s.valueSize;
        if (s.valueSize < 0L) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + " (1).");
        }
        int ilen = slen & 0xFFFF;
        assert (s.bytes.length <= ilen);
        if (length == 0) {
            if (s.valueSize > Integer.MAX_VALUE) {
                throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (2).");
            }
            length = (int)s.valueSize;
        }
        if ((rSize = s.valueSize - offset) < (long)length) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (3).");
        }
        if (length <= 65535) {
            return s.bytes;
        }
        byte[] bytes = new byte[length];
        int left = length - s.bytes.length;
        int cur = s.bytes.length;
        offset += (long)s.bytes.length;
        System.arraycopy(s.bytes, 0, bytes, 0, cur);
        while (left > 0) {
            slen = (short)Math.min(left, 65535);
            s = this.getResourceSegment(resourceIndex, clusterUID, offset, slen);
            ilen = slen & 0xFFFF;
            if (s.valueSize != VALUE_SIZE || s.bytes.length != ilen) {
                throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " blen=" + s.bytes.length + " (4).");
            }
            System.arraycopy(s.bytes, 0, bytes, cur, s.bytes.length);
            left -= s.bytes.length;
            cur += s.bytes.length;
            offset += (long)s.bytes.length;
        }
        return bytes;
    }

    public long getResourceValueSize(int resourceIndex, ClusterUID clusterUID) throws DatabaseException {
        ResourceSegment s = this.getResourceSegment(resourceIndex, clusterUID, 0L, (short)-1);
        if (s.valueSize < 0L) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " size=" + s.valueSize);
        }
        return s.valueSize;
    }

    int wait4RequestsLess(int limit) throws DatabaseException {
        this.dbSession.execute("");
        return 0;
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void updateLastChangeSetId(int thread, final long csid, boolean refresh) {
        if (this.listener != null) {
            this.listener.onChangeSetId(thread, csid, refresh);
        }
        if (csid > this.lastChangeSetId) {
            this.lastChangeSetId = csid;
            final Iterator<ManagementSupport.ChangeSetListener> it = this.changeSetListeners.iterator();
            ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    while (it.hasNext()) {
                        ManagementSupport.ChangeSetListener l = (ManagementSupport.ChangeSetListener)it.next();
                        try {
                            l.onChanged(csid);
                        }
                        catch (Throwable t) {
                            Logger.defaultLogError((Throwable)t);
                        }
                    }
                }
            });
        }
    }

    protected abstract ServerInformationImpl getServerInformation() throws DatabaseException;

    public abstract void acceptCommit(long var1, long var3, byte[] var5) throws DatabaseException;

    public abstract void cancelCommit(long var1, long var3, byte[] var5, SynchronizeContextI var6) throws DatabaseException;

    public abstract void endTransaction(long var1, boolean var3) throws DatabaseException;

    public abstract long askWriteTransaction(int var1, long var2) throws DatabaseException;

    public abstract long askReadTransaction(int var1) throws DatabaseException;

    public abstract void stop() throws DatabaseException;

    public abstract long reserveIds(int var1) throws DatabaseException;

    public ClusterUID[] listClusters() throws InternalException {
        Database.Session.ClusterIds t = this.dbSession.getClusterIds();
        long[] first = t.getFirst();
        long[] second = t.getSecond();
        int N1 = first == null ? 0 : first.length;
        N1 = Math.min(N1, t.getStatus());
        int N2 = second == null ? 0 : second.length;
        N2 = Math.min(N1, N2);
        ClusterUID[] clusters = new ClusterUID[N2];
        int i = 0;
        while (i < N2) {
            clusters[i] = new ClusterUID(first[i], second[i]);
            ++i;
        }
        return clusters;
    }

    public boolean rolledback() {
        return this.dbSession.rolledback();
    }

    static interface Listener {
        public void onChangeSetId(int var1, long var2, boolean var4);
    }

    static class MetadataCache {
        private final boolean DEBUG = false;
        private final int SIZE = 10;
        private int lastInd;
        private long lastId;
        private int count;
        Vector<byte[]> buffer;

        MetadataCache() {
            this.init();
        }

        public int clear() {
            int ret = this.count;
            this.init();
            return ret;
        }

        private void init() {
            this.lastInd = -1;
            this.lastId = 0L;
            this.count = 0;
            this.buffer = new Vector();
            this.buffer.setSize(10);
        }

        private boolean incLastInd() {
            ++this.lastInd;
            if (this.lastInd >= 10) {
                this.lastInd = 0;
                return true;
            }
            return false;
        }

        synchronized void addNext(long id, byte[] data) throws DatabaseException {
            if (this.lastId != 0L && this.lastId != id - 1L) {
                this.init();
            }
            this.incLastInd();
            this.buffer.set(this.lastInd, data);
            this.lastId = id;
            if (this.count < 10) {
                ++this.count;
            }
        }

        synchronized byte[] get(long id) {
            if (id > this.lastId || id <= this.lastId - (long)this.count) {
                return null;
            }
            int ind = this.lastInd - (int)(this.lastId - id);
            if (ind < 0) {
                ind += 10;
            }
            byte[] found = this.buffer.get(ind);
            return found;
        }
    }

    private static class ResourceSegment {
        public long valueSize;
        public byte[] bytes;

        ResourceSegment(long valueSize, byte[] bytes) {
            this.valueSize = valueSize;
            this.bytes = bytes;
        }
    }
}

