/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import org.simantics.db.ExternalValueSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.ResourceImpl;

public class ExternalValueSupportImpl
implements ExternalValueSupport {
    private final boolean DEBUG = false;
    private final SessionImplSocket session;
    private ClusterTranslator clusterTranslator;
    private final ClusterTable clusterTable;

    ExternalValueSupportImpl(SessionImplSocket session) {
        this.session = session;
        this.clusterTranslator = session.clusterTranslator;
        this.clusterTable = session.getClusterTable();
    }

    private final void check4Translator() {
        if (this.clusterTranslator == null) {
            this.clusterTranslator = this.session.clusterTranslator;
        }
    }

    public void writeValue(WriteGraph graph, Resource resource, long offset, int length, byte[] bytes) throws DatabaseException {
        this.check4Translator();
        assert (length <= bytes.length);
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        Object cluster = this.clusterTable.getClusterByResourceKey(resourceImpl.id);
        cluster.modiValueEx(resourceImpl.id, offset, length, bytes, 0, (ClusterSupport)this.clusterTranslator);
    }

    public byte[] readValue(ReadGraph graph, Resource resource, long offset, int length) throws DatabaseException {
        this.check4Translator();
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        Object cluster = this.clusterTable.getClusterByResourceKey(resourceImpl.id);
        return cluster.readValueEx(resourceImpl.id, offset, length, (ClusterSupport)this.clusterTranslator);
    }

    public long getValueSize(ReadGraph graph, Resource resource) throws DatabaseException {
        this.check4Translator();
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        Object cluster = this.clusterTable.getClusterByResourceKey(resourceImpl.id);
        long size = cluster.getValueSizeEx(resourceImpl.id, (ClusterSupport)this.clusterTranslator);
        return size;
    }

    public void removeValue(WriteGraph graph, Resource resource) throws DatabaseException {
        this.check4Translator();
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        Object cluster = this.clusterTable.getClusterByResourceKey(resourceImpl.id);
        cluster.modiValueEx(resourceImpl.id, 0L, 0, new byte[0], 0, (ClusterSupport)this.clusterTranslator);
        cluster.removeValue(resourceImpl.id, (ClusterSupport)this.clusterTranslator);
    }

    public int wait4RequestsLess(int limit) throws DatabaseException {
        this.check4Translator();
        return this.clusterTranslator.wait4RequestsLess(limit);
    }
}

