/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterCollectorSupport;
import fi.vtt.simantics.procore.internal.ClusterTable;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ClusterCollectorPolicy;

class ClusterCollectorSupportImpl
implements ClusterCollectorSupport {
    private final ClusterTable clusterTable;

    ClusterCollectorSupportImpl(ClusterTable clusterTable) {
        this.clusterTable = clusterTable;
    }

    @Override
    public void setPolicy(ClusterCollectorPolicy policy) {
        this.clusterTable.setCollectorPolicy(policy);
    }

    @Override
    public int getCurrentSize() {
        return (int)this.clusterTable.getSizeInBytes();
    }

    @Override
    public long getClusterSize(ClusterCollectorPolicy.CollectorCluster id) {
        long clusterId = id.getClusterId();
        ClusterImpl cluster = this.clusterTable.getClusterByClusterId(clusterId);
        if (cluster == null) {
            throw new IllegalStateException("Asked size of a nonexistent cluster " + clusterId);
        }
        return cluster.getCachedSize();
    }

    @Override
    public Iterable<ClusterCollectorPolicy.CollectorCluster> getResidentClusters() {
        return this.clusterTable.getCollectorClusters();
    }

    @Override
    public void release(ClusterCollectorPolicy.CollectorCluster id) {
        this.clusterTable.release(id);
    }
}

