/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.StatementChangeImpl;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.simantics.db.ChangeSet;
import org.simantics.db.Disposable;
import org.simantics.db.Resource;
import org.simantics.db.common.internal.config.InternalClientConfig;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ResourceImpl;

public final class ClientChangesImpl
implements ChangeSet,
Disposable {
    private static final boolean ASSERT_ALIVE = true;
    private static final byte[] EMPTY = new byte[0];
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 131072;
    private static final byte CLAIM = 1;
    private static final byte DENY = 2;
    private static final byte VALUE = 3;
    private static final byte TERM = 4;
    private static final byte INVALIDATE = 5;
    private boolean disposed = false;
    private SessionImplSocket session;
    private boolean overflow = false;
    private byte[] readBytes = new byte[131072];
    private byte[] writeBytes = this.readBytes;
    private int readBufferIndex = 0;
    private int writeBufferIndex = 0;
    private boolean wroteSinceLastRead = true;
    private ByteBuffer readBuffer = ByteBuffer.wrap(this.readBytes);
    private ByteBuffer writeBuffer = ByteBuffer.wrap(this.writeBytes);
    private File tempFile;
    private RandomAccessFile file;
    private FileChannel channel;
    private long currentPosition = 0L;
    private long readPosition = 0L;
    private long writePosition = 0L;
    private boolean notEmpty = false;
    private int sCache1 = -1;
    private int sCache2 = -1;
    private int sCache3 = -1;

    ClientChangesImpl(SessionImplSocket session) {
        this.session = session;
    }

    public String toDebugString() {
        Object to = "";
        for (ChangeSet.StatementChange s : this.changedStatements()) {
            String op = s.isClaim() ? "add" : "rem";
            if (((String)(to = (String)to + "\n" + op + " " + String.valueOf(s.getSubject()) + " " + String.valueOf(s.getPredicate()) + " " + String.valueOf(s.getObject()))).length() <= 10000) continue;
            to = (String)to + "... more.\n";
            return to;
        }
        for (Resource r : this.changedValues()) {
            if (((String)(to = (String)to + "\nmod " + String.valueOf(r))).length() <= 10000) continue;
            to = (String)to + "...etc.\n";
            return to;
        }
        return to;
    }

    private Resource getResource(int id) {
        return this.session.getResource(id);
    }

    public synchronized Collection<ChangeSet.StatementChange> changedStatements() {
        this.assertAlive();
        if (!this.resetRead()) {
            return Collections.emptyList();
        }
        return new CollectionBase<ChangeSet.StatementChange>(){
            private ChangeSet.StatementChange next = this.seek();

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            ChangeSet.StatementChange seek() {
                try {
                    block8: while (true) {
                        byte method = ClientChangesImpl.this.readByte();
                        switch (method) {
                            case 4: {
                                return null;
                            }
                            case 1: {
                                Resource s = ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                Resource p = ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                Resource o = ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                return new StatementChangeImpl(s, p, o, true);
                            }
                            case 2: {
                                Resource s = ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                Resource p = ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                Resource o = ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                return new StatementChangeImpl(s, p, o, false);
                            }
                            case 3: 
                            case 5: {
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                continue block8;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeDatabaseException((Throwable)e);
                }
            }

            @Override
            public Iterator<ChangeSet.StatementChange> iterator() {
                return new NoRemoveIterator<ChangeSet.StatementChange>(){

                    @Override
                    public boolean hasNext() {
                        return next != null;
                    }

                    @Override
                    public ChangeSet.StatementChange next() {
                        ChangeSet.StatementChange result = next;
                        next = this.seek();
                        return result;
                    }
                };
            }
        };
    }

    public Collection<Resource> changedValues() {
        this.assertAlive();
        if (!this.resetRead()) {
            return Collections.emptyList();
        }
        return new CollectionBase<Resource>(){
            private Resource next = this.seek();

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            Resource seek() {
                try {
                    block8: while (true) {
                        byte method = ClientChangesImpl.this.readByte();
                        switch (method) {
                            case 4: {
                                return null;
                            }
                            case 1: {
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                continue block8;
                            }
                            case 2: {
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                continue block8;
                            }
                            case 3: 
                            case 5: {
                                return ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            public Iterator<Resource> iterator() {
                return new NoRemoveIterator<Resource>(){

                    @Override
                    public boolean hasNext() {
                        return next != null;
                    }

                    @Override
                    public Resource next() {
                        Resource result = next;
                        next = this.seek();
                        return result;
                    }
                };
            }
        };
    }

    public Collection<Resource> changedResources() {
        this.assertAlive();
        if (!this.resetRead()) {
            return Collections.emptyList();
        }
        return new CollectionBase<Resource>(){
            private Resource next = this.seek();

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            Resource seek() {
                try {
                    block9: while (true) {
                        byte method = ClientChangesImpl.this.readByte();
                        switch (method) {
                            case 4: {
                                return null;
                            }
                            case 1: {
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                continue block9;
                            }
                            case 2: {
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                continue block9;
                            }
                            case 3: {
                                ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                                continue block9;
                            }
                            case 5: {
                                return ClientChangesImpl.this.getResource(ClientChangesImpl.this.readInt());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            public Iterator<Resource> iterator() {
                return new NoRemoveIterator<Resource>(){

                    @Override
                    public boolean hasNext() {
                        return next != null;
                    }

                    @Override
                    public Resource next() {
                        Resource result = next;
                        next = this.seek();
                        return result;
                    }
                };
            }
        };
    }

    public boolean isEmpty() {
        if (this.notEmpty) {
            return false;
        }
        return this.writeBufferIndex == 0 && !this.overflow;
    }

    void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    void claim(Resource s, Resource p, Resource o) {
        this.assertAlive();
        this.writeByte(1);
        this.writeInt(this.session.getId((ResourceImpl)s));
        this.writeInt(this.session.getId((ResourceImpl)p));
        this.writeInt(this.session.getId((ResourceImpl)o));
    }

    final void invalidate(int s) {
        this.assertAlive();
        if (s == this.sCache1) {
            return;
        }
        if (s == this.sCache2) {
            this.sCache2 = this.sCache1;
            this.sCache1 = s;
            return;
        }
        if (s == this.sCache3) {
            this.sCache3 = this.sCache2;
            this.sCache2 = this.sCache1;
            this.sCache1 = s;
            return;
        }
        this.sCache3 = this.sCache2;
        this.sCache2 = this.sCache1;
        this.sCache1 = s;
        this.writeByte(5);
        this.writeInt(s);
    }

    void claim(int s, int p, int o) {
        this.assertAlive();
        this.writeByte(1);
        this.writeInt(s);
        this.writeInt(p);
        this.writeInt(o);
    }

    void deny(Resource s, Resource p, Resource o) {
        this.assertAlive();
        this.writeByte(2);
        this.writeInt(this.session.getId((ResourceImpl)s));
        this.writeInt(this.session.getId((ResourceImpl)p));
        this.writeInt(this.session.getId((ResourceImpl)o));
    }

    void deny(int s, int p, int o) {
        this.assertAlive();
        this.writeByte(2);
        this.writeInt(s);
        this.writeInt(p);
        this.writeInt(o);
    }

    void claimValue(Resource r) {
        this.assertAlive();
        this.writeByte(3);
        this.writeInt(this.session.getId((ResourceImpl)r));
    }

    void claimValue(int r) {
        this.assertAlive();
        this.writeByte(3);
        this.writeInt(r);
    }

    private byte readByte() {
        byte result = this.readBytes[this.readBufferIndex++];
        if (this.readBufferIndex == 131072) {
            this.fillReadBuffer();
        }
        return result;
    }

    private int readInt() {
        int ri = this.readBufferIndex;
        int remaining = 131072 - ri;
        switch (remaining) {
            case 0: {
                this.fillReadBuffer();
            }
            default: {
                int result = this.readBytes[ri] & 0xFF | (this.readBytes[ri + 1] & 0xFF) << 8 | (this.readBytes[ri + 2] & 0xFF) << 16 | (this.readBytes[ri + 3] & 0xFF) << 24;
                this.readBufferIndex += 4;
                return result;
            }
            case 4: {
                int result = this.readBytes[ri] & 0xFF | (this.readBytes[ri + 1] & 0xFF) << 8 | (this.readBytes[ri + 2] & 0xFF) << 16 | (this.readBytes[ri + 3] & 0xFF) << 24;
                this.fillReadBuffer();
                return result;
            }
            case 3: {
                int result = this.readBytes[ri] & 0xFF | (this.readBytes[ri + 1] & 0xFF) << 8 | (this.readBytes[ri + 2] & 0xFF) << 16;
                this.fillReadBuffer();
                return result |= (this.readBytes[this.readBufferIndex++] & 0xFF) << 24;
            }
            case 2: {
                int result = this.readBytes[ri] & 0xFF | (this.readBytes[ri + 1] & 0xFF) << 8;
                this.fillReadBuffer();
                ri = this.readBufferIndex;
                this.readBufferIndex += 2;
                return result |= (this.readBytes[ri] & 0xFF) << 16 | (this.readBytes[ri + 1] & 0xFF) << 24;
            }
            case 1: 
        }
        int result = this.readBytes[ri] & 0xFF;
        this.fillReadBuffer();
        ri = this.readBufferIndex;
        this.readBufferIndex += 3;
        return result |= (this.readBytes[ri] & 0xFF) << 8 | (this.readBytes[ri + 1] & 0xFF) << 16 | (this.readBytes[ri + 2] & 0xFF) << 24;
    }

    private void writeByte(int b) {
        this.writeBytes[this.writeBufferIndex++] = (byte)b;
        if (this.writeBufferIndex == 131072) {
            this.flushWriteBuffer(131072);
        }
        this.wroteSinceLastRead = true;
    }

    private void writeInt(int i) {
        int wi = this.writeBufferIndex;
        int room = 131072 - wi;
        switch (room) {
            case 0: {
                this.flushWriteBuffer(131072);
            }
            default: {
                this.writeBytes[wi] = (byte)(i & 0xFF);
                this.writeBytes[wi + 1] = (byte)(i >>> 8 & 0xFF);
                this.writeBytes[wi + 2] = (byte)(i >>> 16 & 0xFF);
                this.writeBytes[wi + 3] = (byte)(i >>> 24 & 0xFF);
                this.writeBufferIndex += 4;
                break;
            }
            case 4: {
                this.writeBytes[wi] = (byte)(i & 0xFF);
                this.writeBytes[wi + 1] = (byte)(i >>> 8 & 0xFF);
                this.writeBytes[wi + 2] = (byte)(i >>> 16 & 0xFF);
                this.writeBytes[wi + 3] = (byte)(i >>> 24 & 0xFF);
                this.flushWriteBuffer(131072);
                break;
            }
            case 3: {
                this.writeBytes[wi] = (byte)(i & 0xFF);
                this.writeBytes[wi + 1] = (byte)(i >>> 8 & 0xFF);
                this.writeBytes[wi + 2] = (byte)(i >>> 16 & 0xFF);
                this.flushWriteBuffer(131072);
                this.writeBytes[this.writeBufferIndex++] = (byte)(i >>> 24 & 0xFF);
                break;
            }
            case 2: {
                this.writeBytes[wi] = (byte)(i & 0xFF);
                this.writeBytes[wi + 1] = (byte)(i >>> 8 & 0xFF);
                this.flushWriteBuffer(131072);
                wi = this.writeBufferIndex;
                this.writeBytes[wi] = (byte)(i >>> 16 & 0xFF);
                this.writeBytes[wi + 1] = (byte)(i >>> 24 & 0xFF);
                this.writeBufferIndex += 2;
                break;
            }
            case 1: {
                this.writeBytes[wi] = (byte)(i & 0xFF);
                this.flushWriteBuffer(131072);
                wi = this.writeBufferIndex;
                this.writeBytes[wi] = (byte)(i >>> 8 & 0xFF);
                this.writeBytes[wi + 1] = (byte)(i >>> 16 & 0xFF);
                this.writeBytes[wi + 2] = (byte)(i >>> 24 & 0xFF);
                this.writeBufferIndex += 3;
            }
        }
        this.wroteSinceLastRead = true;
    }

    private int tryFlushBuffer(int size) throws IOException {
        if (this.tempFile == null) {
            File base = InternalClientConfig.DB_CLIENT_TEMP_DIR;
            base.mkdirs();
            this.tempFile = File.createTempFile("cset-", ".cs", base);
            this.file = new RandomAccessFile(this.tempFile, "rwd");
            this.channel = this.file.getChannel();
        }
        int wrote = 0;
        this.writeBuffer.position(0);
        this.writeBuffer.limit(size);
        while (wrote < size) {
            wrote += this.channel.write(this.writeBuffer);
        }
        return wrote;
    }

    private void flushWriteBuffer(int size) {
        if (size == 0) {
            return;
        }
        if (!this.overflow) {
            this.writeBytes = Arrays.copyOf(this.readBytes, this.readBytes.length);
            this.writeBuffer = ByteBuffer.wrap(this.writeBytes);
            this.overflow = true;
        }
        this.writeBufferIndex = 0;
        int wrote = 0;
        try {
            try {
                this.setFilePosition(this.writePosition);
                wrote = this.tryFlushBuffer(size);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        finally {
            try {
                this.writePosition = this.currentPosition = this.channel.position();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean resetRead() {
        try {
            if (this.wroteSinceLastRead) {
                this.writeByte(4);
                this.wroteSinceLastRead = false;
            }
            if (this.overflow) {
                this.flushWriteBuffer(this.writeBufferIndex);
                this.readPosition = 0L;
                this.setFilePosition(this.readPosition);
                this.fillReadBuffer();
            } else {
                this.readBufferIndex = 0;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void fillReadBuffer() {
        this.readBufferIndex = 0;
        int read = 0;
        try {
            this.setFilePosition(this.readPosition);
            this.readBuffer.position(0);
            this.readBuffer.limit(131072);
            while (read < 131072) {
                int got = this.channel.read(this.readBuffer);
                if (got == -1) {
                    return;
                }
                try {
                    read += got;
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        finally {
            try {
                this.readPosition = this.currentPosition = this.channel.position();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean setFilePosition(long newPosition) throws IOException {
        if (this.channel == null) {
            return false;
        }
        if (newPosition != this.currentPosition) {
            this.channel.position(newPosition);
            this.currentPosition = newPosition;
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        block8: {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            this.session = null;
            this.channel = null;
            if (this.file != null) {
                try {
                    try {
                        this.file.close();
                    }
                    catch (IOException iOException) {
                        this.file = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.file = null;
                    throw throwable;
                }
                this.file = null;
            }
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        this.readBytes = EMPTY;
        this.readBuffer = ByteBuffer.wrap(EMPTY);
        this.writeBytes = EMPTY;
        this.writeBuffer = ByteBuffer.wrap(EMPTY);
    }

    private void assertAlive() {
    }

    public void dispose() {
        this.close();
    }

    public static void main(String[] args) {
        ClientChangesImpl ccs = new ClientChangesImpl(null);
        System.out.println("isEmpty=" + ccs.isEmpty());
        System.out.println("clientChanges=" + ccs.toString());
        System.out.println("isEmpty=" + ccs.isEmpty());
    }

    static class CollectionBase<T>
    implements Collection<T> {
        CollectionBase() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <TT> TT[] toArray(TT[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class NoRemoveIterator<T>
    implements Iterator<T> {
        NoRemoveIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

