package fi.vtt.simantics.procore.internal;

import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ClusterBuilder.StatementHandle;

final public class StatementHandleImpl implements StatementHandle {

    final int pKey;
    final int oKey;
    final byte pForeign;
    final byte oForeign;
    final ClusterUID pClusterUID;
    final ClusterUID oClusterUID;

    public StatementHandleImpl(int pKey, byte pForeign, int oKey, byte oForeign,
            ClusterUID pClusterUID, ClusterUID oClusterUID)  {
        this.pKey = pKey;
        this.oKey = oKey;
        this.pForeign = pForeign;
        this.oForeign = oForeign;
        this.pClusterUID = pClusterUID;
        this.oClusterUID = oClusterUID;
    }
    
    public void apply(Object cluster) {

        ClusterImpl impl = (ClusterImpl)cluster;
        Change change = impl.change;

        change.addStatementIndex1(pKey, pClusterUID, pForeign, impl.foreignLookup);
        change.addStatementIndex2(oKey, oClusterUID, oForeign, impl.foreignLookup);
        
    }
    
}
