package fi.vtt.simantics.procore.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.simantics.db.Disposable;
import org.simantics.db.IO;
import org.simantics.db.service.ClusterSetsSupport;

public class ClusterSetsSupportImpl2 implements ClusterSetsSupport, Disposable {

    final private static boolean DEBUG = false;
    final private static Map<String, ClusterSets> sClusterSets = new HashMap<String, ClusterSets>();
    private IO read;
    private IO write;
    private String databaseId; // Unique identifier for database of session. Initialized in connect. 
    private ClusterSets clusterSets; // Cluster sets for session. Initialized in connect.
    public ClusterSetsSupportImpl2() {
        this.databaseId = null;
        this.clusterSets = null;
    }

    public synchronized void connect(String databaseId) {
        assert(null == this.databaseId);
        this.databaseId = databaseId;
        clusterSets = sClusterSets.get(databaseId);
        int count = 1;
        if (null == clusterSets) {
            clusterSets = new ClusterSets(read, write, databaseId);
            sClusterSets.put(databaseId, clusterSets);
        } else {
            count = clusterSets.inc();
        }
        if (DEBUG)
            System.out.println("Starting session " + count + " for database=" + databaseId);
        clusterSets.touch();
    }
    @Override
    public synchronized void dispose() {
        if (clusterSets == null)
            return;
        clusterSets.dispose();
        if (0 >= clusterSets.dec()) {
            sClusterSets.remove(databaseId);
            if (DEBUG)
                System.out.println("Stopping session for database=" + databaseId);
        }            
        clusterSets = null;
    }
    public synchronized boolean containsKey(long resourceId) {
        return clusterSets.containsKey(resourceId);
    }
    public synchronized Long get(Long resourceId) {
        return clusterSets.get(resourceId);
    }
    public synchronized void setActiveCluster(long clusterSetResourceId, long clusterId) {
        clusterSets.setActiveCluster(clusterSetResourceId, clusterId);
    }
    @Override
    public void setImmutability(long clusterSetResourceId, boolean immutable) {
        clusterSets.setImmutability(clusterSetResourceId, immutable);
    }
    public synchronized void save() throws IOException {
        clusterSets.save();
    }
    public synchronized Long getSet(long clusterId) {
        return clusterSets.getClusterSet(clusterId);
    }
    @Override
    public void clear() {
        clusterSets.clear();
    }
    @Override
    public void updateWriteIO(IO io) {
        this.write = io;
        if(clusterSets != null) {
            clusterSets.setWriteDirectory(io);
            clusterSets.touch();
        }
    }
    
    @Override
    public void setReadIO(IO io) {
        this.read = io;
    }
    
    @Override
    public void validate(long[] ids) {
        clusterSets.validate(ids);
    }

}
