package fi.vtt.simantics.procore.internal;

import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterCollectorPolicy.CollectorCluster;
import org.simantics.db.service.ClusterControl;

public class ClusterControlImpl implements ClusterControl {

	final private SessionImplSocket session;
	
	ClusterControlImpl(SessionImplSocket session) {
		this.session = session;
	}
	
	@Override
	public ClusterCollectorPolicy setPolicy(ClusterCollectorPolicy newPolicy) {
		return session.clusterTable.collector.setPolicy(newPolicy);
	}
	
    @Override
    public int flushClusters() {
        session.clusterTable.gc();
        System.gc();
        System.gc();
        return session.clusterTable.size();
    }


    @Override
    public int collectClusters(int desiredBytes) {
    	session.clusterTable.collector.collect(desiredBytes);
        return 0;
    }

    @Override
    public int gc(ReadGraph graph) {
    	session.clusterTable.collector.collect();
        return 0;
    }
    
    @Override
    public int gc(ReadGraph graph, int objectiveBytes) {
    	if(objectiveBytes < 0) return gc(graph);
    	if(objectiveBytes > used()) return 0;
    	session.clusterTable.collector.collect(used() - objectiveBytes);
        return 0;
    }

    static class ClusterStateImpl implements ClusterState {
    	public Set<CollectorCluster> ids = new HashSet<CollectorCluster>();
    }
    
    @Override
    public ClusterState getClusterState() {
    	return session.clusterTable.getState();
    }
    
    @Override
    public void restoreClusterState(ClusterState state) {
    	session.clusterTable.restoreState((ClusterStateImpl)state);
    }
    
    @Override
    public int used() {
    	return (int)session.clusterTable.getSizeInBytes();
    }

}
