/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore;

import org.simantics.db.ServerReference;
import org.simantics.db.SessionReference;


/**
 * @author Toni Kalajainen
 */
public class ProCoreSessionReference implements SessionReference {

    public final ProCoreServerReference serverReference;

    public final long sessionId;

    public ProCoreSessionReference(ProCoreServerReference serverReference, long sessionId) {
        assert(serverReference!=null);
        this.serverReference = serverReference;
        this.sessionId = sessionId;
    }

    @Override
    public String toString() {
        return serverReference+"/"+sessionId;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (other == null || !(getClass().equals(other.getClass()))) return false;
        ProCoreSessionReference r = (ProCoreSessionReference) other;
        return r.sessionId==sessionId && r.serverReference.equals(serverReference);
    }

    @Override
    public ServerReference getServerReference() {
        return serverReference;
    }

    public long getSessionId() {
        return sessionId;
    }

}
