package org.simantics.db.procore.internal;

import java.io.IOException;
import java.util.Properties;

import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.Driver;
import org.simantics.db.ReadGraph;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.common.auth.UserAuthenticationAgents;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procore.ProCoreDriver;
import org.simantics.layer0.Layer0;

import fi.vtt.simantics.procore.BackdoorAuthenticator;
import fi.vtt.simantics.procore.SessionManagerSource;
import fi.vtt.simantics.procore.internal.SessionImplVirtual;
import fi.vtt.simantics.procore.internal.SessionImplVirtualInit;

public class ProCoreDriverVirtual implements Driver {
    private static final Boolean          DEBUG         = true;
    private final UserAuthenticator       authenticator = new BackdoorAuthenticator();
    private final UserAuthenticationAgent agent         = UserAuthenticationAgents.staticAgent(authenticator);

    public ProCoreDriverVirtual() {
        initLogging();
    }

    private void initLogging() {
        try {
            SessionManagerSource.getSessionManager();
        } catch (IOException e) {
            if (DEBUG)
                e.printStackTrace();
        }
    }

    @Override
    public Session getSession(String address, Properties args) throws DatabaseException {
        Session s = new SessionImplVirtual(agent);
        if (args.containsKey("builtinInitializer"))
            return new SessionImplVirtualInit(agent);
        else if (args.containsKey("noinitialise")) {
            if (DEBUG)
                System.out.println("noinitialise");
        } else {
            s.syncRequest(new ReadRequest() {
                @Override
                public void run(ReadGraph g) {
                    // Registers Builtins with the session ServiceLocator.
                    Layer0.getInstance(g);
                }
            });
        }
        return s;
    }

    @Override
    public ServerI getServer(String address, Properties info) throws DatabaseException {
        return SessionImplVirtual.newVirtualProCoreServer();
    }

    @Override
    public String getName() {
        return ProCoreDriver.ProCoreDriverNameVirtual;
    }
    @Override
    public DatabaseUserAgent getDatabaseUserAgent(String address) {
        return null;
    }
    @Override
    public void setDatabaseUserAgent(String address, DatabaseUserAgent dbUserAgent) {
    }
    @Override
    public Management getManagement(String address, Properties info) throws DatabaseException {
        return null; // No management for virtual database.
    }

}
