/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

public class IntHashTrait {
    public static final boolean isFree(int a) {
        return FREE_VALUE == a;
    }
    public static final boolean isFull(int a) {
    	return (a & 0x7fffffff) != 0;
        //return a != FREE_VALUE && a != REMOVED_VALUE;
    }
    public static final boolean isRemoved(int a) {
        return REMOVED_VALUE == a;
    }
    public static final int setFree() {
        return FREE_VALUE;
    }
    public static final int setFull(int a) {
		assert(a != FREE_VALUE && a != REMOVED_VALUE);
        return a;
    }
    public static int setRemoved() {
        return REMOVED_VALUE;
    }
    private static final int FREE_VALUE = 0;
    private static final int REMOVED_VALUE = 0x80000000;
}
