package org.simantics.db.procore.cluster;

import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.TableSizeListener;

public class CompleteTableSmall extends CompleteTable {
    public CompleteTableSmall(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(sizeListener, header, headerBase);
    }
    public CompleteTableSmall(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
        super(sizeListener, header, headerBase, ints);
    }

    @Override
    public <Context> boolean foreachPredicate(int setIndex,
            ClusterI.PredicateProcedure<Context> procedure,
            Context context, ClusterSupport support, Modifier modifier)
    throws DatabaseException {
        ForeachPredicate<Context> t = new ForeachPredicate<Context>(procedure, support, modifier);
        return foreachComplete(setIndex, t, context, null, null);
    }

    @Override
    public <Context> boolean foreachObject(int setIndex,
            ClusterI.ObjectProcedure<Context> procedure,
            Context context, ClusterSupport support, Modifier modifier,
            ClusterI.CompleteTypeEnum completeType)
    throws DatabaseException {
        ForeachObject<Context> t = new ForeachObject<Context>
        (procedure, support, modifier, completeType);
        return foreachComplete(setIndex, t, context, null, null);
    }
    
    private static final class ForeachPredicate<Context>
    implements ClusterI.ObjectProcedure<Context> {
        private TIntHashSet completeTypes = new TIntHashSet();
        private ClusterI.PredicateProcedure<Context> procedure; 
        public ForeachPredicate(ClusterI.PredicateProcedure<Context>
            procedure, ClusterSupport support, Modifier modifier) {
            this.procedure = procedure;
        }
        @Override
        public boolean execute(Context context, int completeRef) {
        	ClusterI.CompleteTypeEnum completeType = ClusterTraitsSmall.completeRefAndTypeGetType(completeRef);
            if (!completeTypes.contains(completeType.getValue())) {
                completeTypes.add(completeType.getValue());
                try {
                    int pKey = ClusterTraitsBase.getCompleteTypeResourceKeyFromEnum(completeType);
                    if (procedure.execute(context, pKey, 0))
                        return true; // loop broken by procedure
                } catch (DatabaseException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false; // Continue looping.
        }
        
    }
    private static class ForeachObject<Context>
    implements ClusterI.ObjectProcedure<Context> {
        private ClusterI.ObjectProcedure<Context> procedure; 
        private Modifier modifier;
        private ClusterI.CompleteTypeEnum completeType;
        public ForeachObject(ClusterI.ObjectProcedure<Context>
            procedure, ClusterSupport support, Modifier modifier, ClusterI.CompleteTypeEnum completeType) {
            this.procedure = procedure;
            this.modifier = modifier;
            this.completeType = completeType;
        }
        @Override
        public boolean execute(Context context, int completeRef) throws DatabaseException {
        	ClusterI.CompleteTypeEnum completeType2 = ClusterTraitsSmall.completeRefAndTypeGetType(completeRef);
            if (completeType == completeType2) { // same predicate
                int objectRef = ClusterTraitsSmall.completeRefAndTypeGetRef(completeRef);
                int externalRef;
                if (null == modifier)
                    externalRef = objectRef;
                else
                    externalRef = modifier.execute(objectRef);
                return procedure.execute(context, externalRef);
            }
            return false; // Continue looping.
        }
        
    }
}
