/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;

public class ClusterPrintDebugInfo
implements ClusterI.ObjectProcedure<Integer> {
    private ClusterBase cluster;
    private ClusterSupport support;
    private ObjectTable ot;
    private int n = 0;
	public ClusterPrintDebugInfo(ClusterBase cluster, ResourceTable resourceTable
			, PredicateTable predicateTable, ClusterSupport support,
		     ObjectTable ot) throws DatabaseException {
		this.cluster = cluster;
		if (null == support)
		    throw new DatabaseException("Illegal argument.");
		this.support = support;
		this.ot = ot;
	}
	
    @Override
    public boolean execute(Integer i, int resourceRef) {
        int resourceKey;
        try {
            resourceKey = ClusterTraits.createResourceKey(cluster.getClusterKey(), resourceRef);
        } catch (DatabaseException e) {
            e.printStackTrace();
            return false; // continue loop
        }
        CalculateStatements cs = new CalculateStatements(resourceRef, ot);
        try {
            cluster.forPredicates(resourceKey, cs, cs, support);
        } catch (Throwable t) {
            t.printStackTrace();
        }
        return false; // continue loop
    }
	public int getSize() {
		return n;
	}
	
}
