package org.simantics.db.procore.cluster;

final class BitUtility {
	static final long LongBits = 64;
	static final int IntBits = 32;
    static final short ShortBits = 16;
    static final long ClearHighIntMask = (1L << IntBits) - 1;
    static final long ClearLowIntMask = -1l ^ ClearHighIntMask;
    static final long ClearHighShortMask = (1L << ShortBits) - 1;
    static final long ClearLowShortMask  = -1L ^ ClearHighShortMask;

    static final int getHighInt(long longValue) {
        return (int) (longValue >>> IntBits);
    }

    static final long setHighInt(long longValue, int highValue) {
        longValue = (longValue & ClearHighIntMask) | (long) highValue << IntBits;
        return longValue;
    }

    static final int getLowInt(long longValue) {
        return (int) longValue;
    }

    static final long setLowInt(long longValue, int lowValue) {
        longValue = (longValue & ClearLowIntMask) | lowValue;
        return longValue;
    }

    static final long setLowAndHighInt(long longValue, int lowValue, int highValue) {
        longValue = ((long) lowValue & ClearHighIntMask) | ((long) highValue << IntBits);
        return longValue;
    }

    static final short getLowShort(long longValue) {
        return (short)longValue;
    }

    static final long setLowShort(long longValue, short lowValue) {
        longValue = (longValue & ClearLowShortMask) | (lowValue & ClearHighShortMask);
        return longValue;
    }

    static final int getMiddle(final long longValue, final int skip, final int size) {
        return (int)(longValue >>> skip) & (1<<size)-1;
    }

    static final long setMiddle(long longValue, final int skip, final int size, int value) {
    	long a1 = (1L<<size)-1;
    	long m1 = (a1 << skip);
    	long mask = -1L ^ m1;
    	long t1 = (value & a1) << skip;
    	long t2 = longValue & mask;
        long t3 = t2 | t1;
        return t3;
    }

}
