package fi.vtt.simantics.procore.internal;

import java.util.concurrent.Semaphore;

import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.WriteTraits;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T> result value type
 */
public class WriteStateBase<T> {

    final protected WriteTraits request;
    final protected Semaphore notify;
    final protected Procedure<T> procedure;

    protected T result;
    protected Throwable exception;

    public WriteStateBase(WriteTraits request, Semaphore notify, Procedure<T> procedure) {
        assert(request != null);

        this.request = request;
        this.notify = notify;
        this.procedure = procedure;
    }

    public WriteTraits getRequest() {
        return request;
    }

    @SuppressWarnings("unchecked")
    public void setResult(Object result) {
        this.result = (T) result;
    }

    public void except(Throwable throwable) {
        this.exception = throwable;
    }

//    public void cancel(CancelTransactionException e) {
//        this.exception = e;
//    }
//
//    public boolean isCanceled() {
//        return exception instanceof CancelTransactionException;
//    }

    public boolean isExcepted() {
        return exception != null;
    }

    public void finish() {

        if(procedure != null) {

            try {
                // Callback is client code, we have to be prepared for it to throw unexpected exceptions.
                // All we can do here is to log those, can't really pass them anywhere.
                if (procedure != null) {
                    if(isExcepted()) {
                        if(exception instanceof DatabaseException) procedure.exception(exception);
                        else procedure.exception(new DatabaseException(exception));
                    }
                    else procedure.execute(result);
                }
            } catch (Throwable t) {
                Logger.defaultLogError("Write request callback caused an unexpected error, see exception.", t);
                if (SessionImplSocket.DEBUG)
                    t.printStackTrace();
            }

        }

        if(notify != null) notify.release();

    }

}
