package fi.vtt.simantics.procore.internal;

import java.io.InputStream;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.service.ByteReader;
import org.simantics.db.service.TransferableGraphSupport;

public class TransferableGraphSupportImpl implements TransferableGraphSupport {
	
	final private SessionImplSocket session;
	
	TransferableGraphSupportImpl(SessionImplSocket session) {
		this.session = session;
	}

	@Override
	public InputStream getValueStream(ReadGraph graph, Resource resource) {
        return session.getValueStream(null, resource);
	}
	
	@Override
	public byte[] getValue(ReadGraph graph, Resource resource) throws DatabaseException {
		return session.getValue(null, resource);
	}
	
	@Override
	public void setValue(WriteOnlyGraph graph, Resource resource, VirtualGraph provider, byte[] raw) throws DatabaseException {
		
	    WriteGraphImpl impl = (WriteGraphImpl)graph;
	    VirtualGraph vg = session.getProvider(provider);
	    impl.writeSupport.claimValue(vg, resource, raw);
		
	}
	
	@Override
	public void setValue(WriteOnlyGraph graph, Resource resource, VirtualGraph provider, ByteReader reader, int amount)
	        throws DatabaseException {
	    
        WriteGraphImpl impl = (WriteGraphImpl)graph;
        VirtualGraph vg = session.getProvider(provider);
        impl.writeSupport.claimValue(vg, resource, reader, amount);
	    
	}

}
