package fi.vtt.simantics.procore.internal;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.StandardStatement;
import org.simantics.db.service.StatementSupport;

public class StatementSupportImpl implements StatementSupport {
	
	final private SessionImplSocket session;
	
	StatementSupportImpl(SessionImplSocket session) {
		this.session = session;
	}

	@Override
	public Statement build(Resource s, Resource p, Resource o) {
		return new StandardStatement(s, p, o);
	}

	@Override
	public boolean isList(Statement stm) {
		if(stm instanceof DirectStatementImpl) {
			DirectStatementImpl i = (DirectStatementImpl)stm;
			return i.s == i.p;
		}
		throw new Error("Not supported");
	}

	@Override
	public boolean isTag(Statement stm) {
		throw new Error("Not supported");
	}

	@Override
	public boolean objectAsserted(Statement stm) {
		throw new Error("Not supported");
	}

	@Override
	public boolean objectEquals(Statement stm, Resource r) {
		throw new Error("Not supported");
	}

	@Override
	public boolean subjectPersistent(Statement stm) {
		throw new Error("Not supported");
	}

	@Override
	public boolean objectPersistent(Statement stm) {
		throw new Error("Not supported");
	}

	@Override
	public boolean predicateAsserted(Statement stm) {
		throw new Error("Not supported");
	}

	@Override
	public boolean predicateEquals(Statement stm, Resource r) {
		throw new Error("Not supported");
	}

	@Override
	public boolean predicatePersistent(Statement stm) {
		throw new Error("Not supported");
	}

	@Override
	public boolean subjectAsserted(Statement stm) {
		throw new Error("Not supported");
	}

	@Override
	public boolean subjectEquals(Statement stm, Resource r) {
		throw new Error("Not supported");
	}

}
