/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.procore.protocol.Constants;


public abstract class StatementImpl implements Statement {
    public final static StatementImpl[] NONE = new StatementImpl[0];
    public final ResourceImpl subject;
    public final ResourceImpl predicate;
    protected ResourceImpl object;
    public StatementImpl(ResourceImpl subject, ResourceImpl predicate) {
        if (null == subject)
            throw new IllegalArgumentException();
        if(null == predicate)
            throw new IllegalArgumentException();
        this.subject = (ResourceImpl)subject;
        this.predicate = (ResourceImpl)predicate;
    }
    
    public ResourceImpl getObjectImpl() {
        return object;
    }
    @Override
    public Resource getObject() {
        return object;
    }

    @Override
    final public Resource getPredicate() {
        return predicate;
    }

    @Override
    final public Resource getSubject() {
        return subject;
    }

    @Override
    public boolean isAsserted(Resource testSubject) {
    	return !subject.equals(testSubject);
    }
    
    public abstract boolean equals(long s, long p, long o);
    
  }

final class StatementImplOld extends StatementImpl {
    
    public StatementImplOld(ResourceImpl subject, ResourceImpl predicate, ResourceImpl object) {
        super(subject, predicate);
        this.object = (ResourceImpl)object;
    }
    @Override
    public int hashCode() {
        return subject.hashCode() + (int)object.id; 
    }

    @Override
    public boolean equals(long s, long p, long o) {
        return (subject.id == s) && (predicate.id == p) && (object.id == o);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        else if (!(obj instanceof StatementImpl))
            return false;
        StatementImpl r = (StatementImpl)obj;
        return r.equals(subject.id, predicate.id, object.id);
    }
}

final class StatementImplNew extends StatementImpl {
    public final long objectResourceId;
    public final long objectClusterId;
    public final GraphSession graphSession;
    public StatementImplNew(ResourceImpl subject, ResourceImpl predicate, long id, long cluster, GraphSession graphSession) {
        super(subject, predicate);
        this.object = null;
        this.objectResourceId = id;
        if (Constants.ReservedClusterId == cluster)
            throw new IllegalArgumentException("Argh!");
        this.objectClusterId = cluster;
        this.graphSession = graphSession;
    }

    @Override
    final public Resource getObject() {
//        if (null == object)
//            try {
//                object = graphSession.getResourceOrThrow(objectResourceId, objectClusterId);
//            } catch (ResourceNotFoundException e) {
//                e.printStackTrace();
//                return null;
//            }
//        return object;
    	throw new Error("No can do.");
    }

    @Override
    public ResourceImpl getObjectImpl() {
//        if (null == object)
//            try {
//                object = graphSession.getResourceOrThrow(objectResourceId, objectClusterId);
//            } catch (ResourceNotFoundException e) {
//                e.printStackTrace();
//                return null;
//            }
//        return object;
    	throw new Error("No can do.");
    }

    @Override
    public int hashCode() {
        return subject.hashCode() + (int)objectResourceId; 
    }

    @Override
    public boolean equals(long s, long p, long o) {
        return (subject.id == s) && (predicate.id == p) && (objectResourceId == o);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        else if (obj == null)
            return false;
        else if (StatementImpl.class != obj.getClass())
            return false;
        StatementImpl r = (StatementImpl)obj;
        return r.equals(subject.id, predicate.id, objectResourceId);
    }
}
