package fi.vtt.simantics.procore.internal;

import java.util.HashSet;
import java.util.Vector;

import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.TimeoutException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.InitSupport;
import org.simantics.db.service.LifecycleSupport;

public class InitSupportImpl implements InitSupport {
    final private SessionImplSocket session;

    InitSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    @Override
    public void close() throws DatabaseException, TimeoutException {
        session.getService(LifecycleSupport.class).close();
    }

    @Override
    public void addBuiltins(final HashSet<Builtin> builtins)
    throws InternalException {
        try {
            session.syncRequest(new WriteRequest() {
                @Override
                public void perform(WriteGraph graph) throws DatabaseException {
                    ClusterSupport cs = session.getService(ClusterSupport.class);
                    Vector<Builtin> v = new Vector<Builtin>();
                    final int N = builtins.size();
                    v.setSize(N + 1); // Index starts with one, zero left as sentinel.
                    for (Builtin b : builtins) {
                        if (b.index < 1 || b.index > N)
                            throw new RuntimeDatabaseException("Illeagal resource index for builtin."
                            + " index=" + b.index + " uri=" + b.uri + " N=" + N);
                        v.set(b.index, b);
                    }
                    for (int i=1; i<N+1; ++i) {
                        if (v.get(i) == null)
                            throw new RuntimeDatabaseException("Missing builtin for resource index=" + i);
                    }
                    ClusterBase cluster = cs.getClusterByClusterUIDOrMake(ClusterUID.Builtin);
                    long clusterId = cluster.getClusterId();
                    for (int i=1; i<N+1; ++i) {
                        Builtin b = v.get(i);
                        cs.createResource(cluster, (short)b.index, clusterId);
                    }
                    cluster.setImmutable(true, cs);
                }
            });
        } catch (DatabaseException e) {
            throw new InternalException("Failed to init graph.", e);
        }
    }
}
