/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import gnu.trove.map.hash.THashMap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

import org.simantics.db.ClusterCreator;
import org.simantics.db.Database;
import org.simantics.db.SessionReference;
import org.simantics.db.Database.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.support.VirtualGraphServerSupport;
import org.simantics.db.procore.protocol.Constants;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.service.ClusterUID;

class GraphSessionVirtual extends GraphSession { // Äsh! This extends relation was/is a pure design choice.
    private static String FileName = "virtualGraph.builtins.dat";
    private static long BuiltinClusterId = -1; // Virtual graph doesn't have clusters.
    static class VirtualSession implements Session {
        @Override
        public Database getDatabase() {
            return null;
        }
        @Override
        public void close() throws ProCoreException {
        }
        @Override
        public void open() throws ProCoreException {
        }
        @Override
        public boolean isClosed() throws ProCoreException {
            return false;
        }
        @Override
        public String execute(String command) throws ProCoreException {
            return null;
        }
        @Override
        public void acceptCommit(long transactionId, long changeSetId, byte[] metadata) throws ProCoreException {
        }
        @Override
        public long cancelCommit(long transactionId, long changeSetId, byte[] metadata, OnChangeSetUpdate on) throws ProCoreException {
            return 0;
        }
        @Override
        public Transaction askReadTransaction() throws ProCoreException {
            return null;
        }
        @Override
        public Transaction askWriteTransaction(long transactionId) throws ProCoreException {
            return null;
        }
        @Override
        public long endTransaction(long transactionId) throws ProCoreException {
            return 0;
        }
        @Override
        public byte[] getChangeSetMetadata(long changeSetId) throws ProCoreException {
            return null;
        }
        @Override
        public ChangeSetData getChangeSetData(long minChangeSetId, long maxChangeSetId, OnChangeSetUpdate on) throws ProCoreException {
            return null;
        }
        @Override
        public ChangeSetIds getChangeSetIds() throws ProCoreException {
            return null;
        }
        @Override
        public Cluster getCluster(byte[] clusterId) throws ProCoreException {
            return null;
        }
        @Override
        public ClusterChanges getClusterChanges(long changeSetId, byte[] clusterId) throws ProCoreException {
            return null;
        }
        @Override
        public ClusterIds getClusterIds() throws ProCoreException {
            return null;
        }
        @Override
        public Information getInformation() throws ProCoreException {
            return null;
        }
        @Override
        public Refresh getRefresh(long changeSetId) throws ProCoreException {
            return null;
        }
        @Override
        public ResourceSegment getResourceSegment(byte[] clusterUID, int resourceIndex, long offset, short size) throws ProCoreException {
            return null;
        }
        @Override
        public long reserveIds(int count) throws ProCoreException {
            return 0;
        }
        @Override
        public void updateCluster(byte[] operations) throws ProCoreException {
        }
        @Override
        public boolean undo(long[] cChangeSetIds, OnChangeSetUpdate onChangeSetUpdate) throws ProCoreException {
            return false;
        }
        @Override
        public <T> T clone(ClusterUID clusterUID, ClusterCreator clusterCreator) throws DatabaseException {
            throw new UnsupportedOperationException();
        }
        @Override
        public boolean refreshEnabled() {
            return false;
        }
        @Override
        public boolean rolledback() {
            return false;
        }
    }
    private AtomicLong changeSetId = new AtomicLong(Constants.NullChangeSetId);
    private AtomicLong transactionId = new AtomicLong(Constants.NullTransactionId);
    public static ServerInformationImpl serverInfo = new ServerInformationImpl("serverId", "protocolId", "databaseId", 0);
    private VirtualGraphServerSupport virtualGraphServerSupport;
	public GraphSessionVirtual(SessionImplSocket sessionImpl, SessionReference sessionReference, VirtualGraphServerSupport vgss) {
        super(sessionImpl, sessionReference, new VirtualSession()); // Super does not expect null session.
        virtualGraphServerSupport = vgss;
    }
    protected THashMap<String, BuiltinData> initBuiltinMap()
    throws DatabaseException {
        try {
            Properties props = new Properties();
            File from = new File(FileName);
            InputStream in = new FileInputStream(from);
            props.load(in);
            THashMap<String, BuiltinData>  builtins = new THashMap<String, BuiltinData>();
            Set<String> keys = props.stringPropertyNames();
            for (String key : keys) {
                long resourceId = Long.parseLong(key);
                long cluster = BuiltinClusterId;
                int resourceIndex = (int)resourceId;
                String uri = props.getProperty(key);
                BuiltinData bd = new BuiltinData(resourceIndex, cluster);
                builtins.put(uri, bd);
            }
            return builtins;
        } catch(IOException e) {
            if (DEBUG)
                e.printStackTrace();
            throw new DatabaseException("Failed to read builtins.", e);
        }
    }
    @Override
    protected ServerInformationImpl getServerInformation() {
        return serverInfo;
    }
    @Override
    public void acceptCommit(long transactionId, long csid, byte[] metadata)
    throws DatabaseException {
        changeSetId.incrementAndGet();
    }

    @Override
    public void cancelCommit(long transactionId, long csid, byte[] metadata, SynchronizeContextI context)
    throws DatabaseException {
        changeSetId.incrementAndGet();
    }

    @Override
    public void endTransaction(long transactionId, boolean write)
    throws DatabaseException {

    }

    @Override
    public long askWriteTransaction(int thread, long transactionId)
    throws DatabaseException {
        if (Constants.NullTransactionId != transactionId)
            return transactionId;
        else
            return this.transactionId.incrementAndGet();
    }
    @Override
    public long askReadTransaction(int thread)
    throws DatabaseException {
        return transactionId.incrementAndGet();
    }
    @Override
    public void stop() throws DatabaseException {
        if (DEBUG)
            System.out.println("GraphSessionVirtual: stop.");

    }
    @Override
    public long reserveIds(int count)
    throws DatabaseException {
//        VirtualGraphServerSupport s = session.getService(VirtualGraphServerSupport.class);
        long id = Constants.NullSubjectId;
        for (int i=0; i<count; ++i)
           id = virtualGraphServerSupport.createVirtual();
        return id;
    }
}
