/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import java.util.concurrent.CopyOnWriteArrayList;

import org.simantics.db.service.EventSupport;

/**
 * Simple implementation for Event Support.
 * 
 * Note: for more extended / complicated scenarios, we could use org.simantics.utils.threads.SyncListenerList.
 * 
 * @author luukkainen
 *
 */
public class EventSupportImpl implements EventSupport {
    
    private CopyOnWriteArrayList<EventListener> listeners = new CopyOnWriteArrayList<>();
    
    @Override
    public synchronized void addListener(EventListener l) {
        listeners.add(l);
    }
    
    @Override
    public synchronized void removeListener(EventListener l) {
        listeners.remove(l);
    }
    
    public void fireEvent(String type, Object data) {
        for (EventListener l : listeners) {
            l.event(type, data);
        }
    }

}
