package fi.vtt.simantics.procore.internal;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.LinkedList;

public class ClusterChangeManager {
    
    final private THashSet<ClusterChange> clusterChanges = new THashSet<ClusterChange>();
    final private LinkedList<ClusterChange> removeList = new LinkedList<ClusterChange>();
    private int changeCounter = 0;
    private int byteLimit = 65536;
    
    public void checkFlush() {
        if(changeCounter < 50) return;
        ClusterChange test = removeList.poll();
        if(test == null) return;
        if(test.byteIndex > byteLimit) {
            test.flushCollect(null);
        } else {
            removeList.add(test);
        }
    }
    
    public void updateChangeCounters() {
        changeCounter = clusterChanges.size();
        byteLimit = (100-changeCounter)*ClusterChange.MAX_FIXED_BYTES;
    }

    void addChange(ClusterChange change) {
        clusterChanges.add(change);
        updateChangeCounters();
    }

    Collection<ClusterChange> get() {
        return clusterChanges;
    }
    
    void add(ClusterChange change) {
        if(clusterChanges.add(change)) {
            removeList.add(change);
        } else {
            new Exception("trying to add change that already exists " + change.clusterUID + " " + System.identityHashCode(change.clusterImpl)).printStackTrace();
        }
        updateChangeCounters();
    }
    
    void remove(Collection<ClusterChange> changes) {
        clusterChanges.removeAll(changes);
        removeList.removeAll(changes);
        updateChangeCounters();
    }
    
    int size() {
        return clusterChanges.size();
    }
    
    void clear() {
        clusterChanges.clear();
        removeList.clear();
        updateChangeCounters();
    }
    
}
