package fi.vtt.simantics.procore.internal;

import org.simantics.db.VirtualGraph;
import org.simantics.db.service.ClusterBuilder2;
import org.simantics.db.service.ClusterBuilderFactory;

public class ClusterBuilderFactoryImpl implements ClusterBuilderFactory {

    final private SessionImplSocket session;
    
    ClusterBuilderFactoryImpl(SessionImplSocket session) {
        this.session = session;
    }
    
    @Override
    public ClusterBuilder2 create(VirtualGraph vg, boolean allowImmutables) {
    	if(vg != null)
    		return new VirtualClusterBuilderImpl2(session, vg, allowImmutables);
    	else
    		return new ClusterBuilderImpl2(session, allowImmutables);
    }

    
}
