package fi.vtt.simantics.procore.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.db.common.utils.Logger;

/**
 * A bundle activator for org.simantics.db.procore that takes care of
 * automatically finding a proper place for storing virtual graph files within
 * the bundle metadata locations.
 *
 * @author Tuukka Lehtonen
 */
public class Activator implements BundleActivator {

    public static final String PLUGIN_ID = "org.simantics.db.procore";

    // The shared instance
    private static Activator plugin;

    private Bundle bundle;

    @Override
    public void start(BundleContext context) throws Exception {
        IPath stateLocation = Platform.getStateLocation(context.getBundle());
        StaticSessionProperties.virtualGraphStoragePath = stateLocation.toFile();
        this.bundle = context.getBundle();
        plugin = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        this.bundle = null;
        plugin = null;
        StaticSessionProperties.virtualGraphStoragePath = null;
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    /**
     * @return
     */
    public static void log(IStatus status) {
        Activator a = getDefault();
        if (a != null) {
            // In OSGi environment
            Platform.getLog(a.bundle).log(status);
        } else {
            Logger.defaultLogError(status.getMessage(), status.getException());
        }
    }

}
