/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Map;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class RelativeReference {
    public final Resource base;
    public final String path;

    public RelativeReference(Resource base, String path) {
        this.base = base;
        this.path = path;
    }

    public Resource resolve(ReadGraph graph) throws DatabaseException {
        return RelativeReference.resolve(graph, this.base, this.path);
    }

    public static Resource resolve(ReadGraph graph, Resource base, String path) throws DatabaseException {
        String[] splitPath;
        String[] stringArray = splitPath = path.split("/");
        int n = splitPath.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if ((base = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(base))).get(URIStringUtils.unescape((String)name))) == null) {
                return null;
            }
            ++n2;
        }
        return base;
    }

    public static RelativeReference createReference(ReadGraph graph, Resource baseType, Resource resource) throws DatabaseException {
        ArrayList<String> path = new ArrayList<String>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        try {
            while (!graph.isInstanceOf(resource, baseType)) {
                path.add((String)graph.getRelatedValue(resource, L0.HasName));
                resource = graph.getSingleObject(resource, L0.PartOf);
            }
        }
        catch (DatabaseException databaseException) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        int i = path.size() - 1;
        while (i >= 0) {
            b.append(URIStringUtils.escape((String)((String)path.get(i))));
            if (i > 0) {
                b.append('/');
            }
            --i;
        }
        return new RelativeReference(resource, b.toString());
    }
}

