/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceMap;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsistsOfProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsistsOfProcess.class);
    final ArrayList<ConsistsOfProcessEntry> result;
    final Set<ConsistsOfProcessEntry> childrenWithNoName;
    final SyncContextMultiProcedure<ConsistsOfProcessEntry, Resource> structure;
    final SyncContextMultiProcedure<ConsistsOfProcessEntry, Resource> names;

    public static Pair<ArrayList<ConsistsOfProcessEntry>, Set<ConsistsOfProcessEntry>> walk(ReadGraph graph, Collection<TransferableGraphConfiguration2.SeedSpec> specs, boolean ignoreVirtual) throws DatabaseException {
        return ConsistsOfProcess.walk(graph, null, specs, ignoreVirtual);
    }

    public static Pair<ArrayList<ConsistsOfProcessEntry>, Set<ConsistsOfProcessEntry>> walk(ReadGraph graph, ResourceMap<SubgraphExtent.ExtentStatus> status, Collection<TransferableGraphConfiguration2.SeedSpec> specs, boolean ignoreVirtual) throws DatabaseException {
        ConsistsOfProcess process = new ConsistsOfProcess(graph, status, specs, ignoreVirtual);
        return Pair.make(process.result, process.childrenWithNoName);
    }

    private ConsistsOfProcess(ReadGraph graph, final ResourceMap<SubgraphExtent.ExtentStatus> status, final Collection<TransferableGraphConfiguration2.SeedSpec> seeds, final boolean ignoreVirtual) throws DatabaseException {
        final Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
        this.result = new ArrayList();
        this.childrenWithNoName = new HashSet<ConsistsOfProcessEntry>();
        this.names = dqs.compileForEachObject(graph, L0.HasName, (SyncContextMultiProcedure)new SyncContextMultiProcedure<ConsistsOfProcessEntry, Resource>(){

            public void execute(ReadGraph graph, ConsistsOfProcessEntry entry, Resource nameResource) throws DatabaseException {
                if (status != null) {
                    status.put((Object)nameResource, (Object)SubgraphExtent.ExtentStatus.EXCLUDED);
                }
                if (!entry.valid) {
                    return;
                }
                String name = (String)graph.getValue(nameResource, (Binding)Bindings.STRING);
                if (name == null) {
                    entry.valid = false;
                } else if (entry.name != null) {
                    entry.valid = false;
                } else {
                    Resource t = graph.getPossibleObject(nameResource, L0.InstanceOf);
                    if (L0.String.equals(t)) {
                        entry.name = name;
                    } else {
                        entry.name = name;
                        entry.valid = false;
                        status.remove((Object)nameResource);
                    }
                }
            }

            public void exception(ReadGraph graph, Throwable throwable) {
                LOGGER.error("Exception while resolving ConsistsOf hierarchy", throwable);
            }

            public void finished(ReadGraph graph, ConsistsOfProcessEntry entry) {
                if (entry.valid) {
                    if (entry.name != null) {
                        ConsistsOfProcess.this.result.add(entry);
                    } else {
                        ConsistsOfProcess.this.childrenWithNoName.add(entry);
                    }
                } else {
                    ConsistsOfProcess.this.childrenWithNoName.add(entry);
                }
            }
        });
        this.structure = dqs.compileForEachObject(graph, L0.ConsistsOf, (SyncContextMultiProcedure)new SyncContextMultiProcedure<ConsistsOfProcessEntry, Resource>(){

            public void execute(ReadGraph graph, ConsistsOfProcessEntry parent, Resource child) {
                if (status != null && SubgraphExtent.ExtentStatus.EXCLUDED.equals(status.get((Object)child))) {
                    return;
                }
                if (!ignoreVirtual || child.isPersistent()) {
                    ConsistsOfProcessEntry entry = new ConsistsOfProcessEntry(parent, child);
                    dqs.forEachObjectCompiled(graph, child, (Object)entry, ConsistsOfProcess.this.structure);
                    dqs.forEachObjectCompiled(graph, child, (Object)entry, ConsistsOfProcess.this.names);
                }
            }

            public void finished(ReadGraph graph, ConsistsOfProcessEntry parent) {
            }

            public void exception(ReadGraph graph, Throwable throwable) {
                LOGGER.error("Exception while resolving ConsistsOf hierarchy", throwable);
            }
        });
        graph.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                for (TransferableGraphConfiguration2.SeedSpec seed : seeds) {
                    SubgraphExtent.ExtentStatus es;
                    if (status != null && (SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)(es = (SubgraphExtent.ExtentStatus)((Object)status.get((Object)seed.resource)))) || SubgraphExtent.ExtentStatus.EXTERNAL.equals((Object)es))) continue;
                    ConsistsOfProcessEntry entry = new ConsistsOfProcessEntry(null, seed.resource);
                    dqs.forEachObjectCompiled(graph, seed.resource, (Object)entry, ConsistsOfProcess.this.structure);
                    if (!TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL.equals((Object)seed.specType)) continue;
                    dqs.forEachObjectCompiled(graph, seed.resource, (Object)entry, ConsistsOfProcess.this.names);
                }
            }
        });
    }

    static class ConsistsOfProcessEntry {
        public ConsistsOfProcessEntry parent;
        public Resource resource;
        public boolean valid = true;
        public String name = null;

        ConsistsOfProcessEntry(ConsistsOfProcessEntry parent, Resource resource) {
            this.parent = parent;
            this.resource = resource;
        }
    }
}

