/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public final class ChildrenByIdentifier
extends ResourceRead<Map<GUID, Resource>> {
    public ChildrenByIdentifier(Resource resource) {
        super(resource);
    }

    public Map<GUID, Resource> perform(ReadGraph graph) throws DatabaseException {
        HashMap<GUID, Resource> result = new HashMap<GUID, Resource>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection children = graph.getObjects(this.resource, L0.ConsistsOf);
        for (Resource child : children) {
            GUID guid = (GUID)graph.getPossibleRelatedValue(child, L0.identifier, GUID.BINDING);
            if (guid == null) continue;
            result.put(guid, child);
        }
        return result;
    }
}

