/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TypeString;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

class Entry
implements Comparable<Entry> {
    final Resource parent;
    final Resource resource;
    String types;
    String name;
    String id;
    String typeId;
    Resource principalType;
    byte[] guid;

    Entry(Resource parent, Resource resource, String name, String types, String id) {
        this.parent = parent;
        this.resource = resource;
        this.name = name;
        this.types = types;
        this.id = id;
    }

    Entry(ReadGraph graph, Layer0 L0, Resource resource) throws DatabaseException {
        this.parent = graph.getPossibleObject(resource, L0.PartOf);
        this.resource = resource;
        this.name = (String)graph.getPossibleRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
        Set typeSet = graph.getTypes(resource);
        this.types = (String)graph.syncRequest((Read)new TypeString(L0, typeSet));
        this.id = IndexQueries.idFromGUID((GUID)graph.getPossibleRelatedValue(resource, L0.identifier, GUID.BINDING));
        this.typeId = IndexQueries.toResourceIdString(typeSet);
    }

    Entry(ReadGraph graph, Resource resource) throws DatabaseException {
        this(graph, Layer0.getInstance((ReadGraph)graph), resource);
    }

    @Override
    public int compareTo(Entry o) {
        int names = this.name.compareTo(o.name);
        if (names != 0) {
            return names;
        }
        int resources = this.resource.compareTo((Object)o.resource);
        if (resources != 0) {
            return resources;
        }
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        Entry other = (Entry)obj;
        return this.resource.equals(other.resource);
    }
}

