/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.annotations.Arguments;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyChanges
implements Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyChanges.class);
    @Arguments(value={Resource.class, Change[].class})
    public final TreeMap<Resource, Change[]> modelChanges;
    public final boolean hasUnresolved;

    public DependencyChanges(TreeMap<Resource, Change[]> modelChanges, boolean hasUnresolved) {
        this.modelChanges = modelChanges;
        this.hasUnresolved = hasUnresolved;
    }

    public DependencyChanges(Map<Resource, ArrayList<Change>> _modelChanges, boolean hasUnresolved) {
        this(new TreeMap<Resource, Change[]>(), hasUnresolved);
        for (Map.Entry<Resource, ArrayList<Change>> entry : _modelChanges.entrySet()) {
            ArrayList<Change> value = entry.getValue();
            this.modelChanges.put(entry.getKey(), value.toArray(new Change[value.size()]));
        }
    }

    public Change[] get(Resource model) {
        return this.modelChanges.get(model);
    }

    public Map<Resource, Change[]> get() {
        return this.modelChanges;
    }

    public byte[] serialise(Session session) {
        try {
            Databoard databoard = (Databoard)session.getService(Databoard.class);
            Binding binding = databoard.getBinding(DependencyChanges.class);
            Serializer serializer = databoard.getSerializer(binding);
            return serializer.serialize((Object)this);
        }
        catch (IOException | BindingConstructionException | SerializerConstructionException e) {
            LOGGER.error("Could not serialise {} {}", new Object[]{this.getClass().getSimpleName(), this, e});
            return new byte[0];
        }
    }

    public static DependencyChanges deserialise(Session session, byte[] input) {
        try {
            Databoard databoard = (Databoard)session.getService(Databoard.class);
            Binding binding = databoard.getBinding(DependencyChanges.class);
            Serializer serializer = databoard.getSerializer(binding);
            return (DependencyChanges)serializer.deserialize(input);
        }
        catch (IOException | BindingConstructionException | SerializerConstructionException e) {
            LOGGER.error("Could not deserialise {}", (Object)Arrays.toString(input), (Object)e);
            return null;
        }
    }

    public boolean isEmpty() {
        return this.modelChanges.isEmpty() && !this.hasUnresolved;
    }

    @Union(value={LinkChange.class, ComponentAddition.class, ComponentRemoval.class, ComponentModification.class})
    public static interface Change {
        public ChangeType getType();

        public String toString(ReadGraph var1) throws DatabaseException;
    }

    public static enum ChangeType {
        LINK_CHANGE,
        COMPONENT_ADDITION,
        COMPONENT_REMOVAL,
        COMPONENT_MODIFICATION;

    }

    public static class ComponentAddition
    implements Change {
        public final Resource component;
        public final Resource parent;

        public ComponentAddition(Resource component, Resource parent) {
            this.component = component;
            this.parent = parent;
        }

        @Override
        public ChangeType getType() {
            return ChangeType.COMPONENT_ADDITION;
        }

        public String toString() {
            return "ComponentAddition[" + String.valueOf(this.component) + "]";
        }

        public boolean isValid(ReadGraph graph) throws DatabaseException {
            return graph.hasStatement(this.component, Layer0.getInstance((ReadGraph)graph).PartOf, this.parent);
        }

        @Override
        public String toString(ReadGraph graph) throws DatabaseException {
            return "ComponentAddition[" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.component, (boolean)true) + "]";
        }
    }

    public static class ComponentModification
    implements Change {
        public final Resource component;

        public ComponentModification(Resource component) {
            this.component = component;
        }

        @Override
        public ChangeType getType() {
            return ChangeType.COMPONENT_MODIFICATION;
        }

        @Override
        public String toString(ReadGraph graph) throws DatabaseException {
            return "ComponentModification[" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.component, (boolean)true) + "]";
        }
    }

    public static class ComponentRemoval
    implements Change {
        public final Resource component;
        public final Resource parent;

        public ComponentRemoval(Resource component, Resource parent) {
            this.component = component;
            this.parent = parent;
        }

        @Override
        public ChangeType getType() {
            return ChangeType.COMPONENT_REMOVAL;
        }

        public boolean isValid(ReadGraph graph) throws DatabaseException {
            return !graph.hasStatement(this.component, Layer0.getInstance((ReadGraph)graph).PartOf, this.parent);
        }

        @Override
        public String toString(ReadGraph graph) throws DatabaseException {
            return "ComponentRemoval[component=" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.component, (boolean)true) + ", parent=" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.parent, (boolean)true) + "]";
        }
    }

    public static class LinkChange
    implements Change {
        public final Resource component;

        public LinkChange(Resource component) {
            this.component = component;
        }

        @Override
        public ChangeType getType() {
            return ChangeType.LINK_CHANGE;
        }

        @Override
        public String toString(ReadGraph graph) throws DatabaseException {
            return "LinkChange[" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.component, (boolean)true) + "]";
        }
    }
}

