/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ChangeSet;
import org.simantics.db.Metadata;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.changeset.GenericChangeListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.SuperTypeString;
import org.simantics.db.common.request.TypeString;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.genericrelation.Dependencies;
import org.simantics.db.layer0.genericrelation.DependenciesListenerStore;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.genericrelation.DependencyChangesWriter;
import org.simantics.db.layer0.genericrelation.Entry;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.genericrelation.UnsupportedRelation;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncContextProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.logging.TimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesRelation
extends UnsupportedRelation
implements GenericRelationIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependenciesRelation.class);
    private static final boolean DEBUG = false;
    static final boolean DEBUG_LISTENERS = false;
    private static final boolean PROFILE = true;
    private static final Pair<String, String>[] fields = new Pair[]{Pair.make((Object)"Model", (Object)"Long"), Pair.make((Object)"Parent", (Object)"Long"), Pair.make((Object)"Resource", (Object)"Long"), Pair.make((Object)"Name", (Object)"String"), Pair.make((Object)"Types", (Object)"Text"), Pair.make((Object)"GUID", (Object)"Text"), Pair.make((Object)"NameSearch", (Object)"Text"), Pair.make((Object)"TypesSearch", (Object)"Text"), Pair.make((Object)"TypeId", (Object)"Text")};
    final Resource resource;
    private static int trackers = 0;
    private static ChangeListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependenciesRelation(ReadGraph graph, Resource resource) {
        this.resource = resource;
        DependenciesRelation dependenciesRelation = this;
        synchronized (dependenciesRelation) {
            Session session = graph.getSession();
            DependenciesListenerStore store = (DependenciesListenerStore)session.peekService(DependenciesListenerStore.class);
            if (store == null) {
                session.registerService(DependenciesListenerStore.class, (Object)new DependenciesListenerStore());
            }
        }
    }

    public ArrayList<Entry> find(ReadGraph graph, Resource model) throws DatabaseException {
        return (DependenciesRelation)this.new Process((ReadGraph)graph, (Resource)model).result;
    }

    @Override
    public GenericRelation select(String bindingPattern, Object[] constants) {
        this.checkSelectionArguments(bindingPattern, constants, new String[]{Dependencies.getBindingPattern()});
        final long subjectId = (Long)constants[0];
        return new UnsupportedRelation(){

            @Override
            public boolean isRealizable() {
                return true;
            }

            @Override
            public final List<Object[]> realize(ReadGraph graph) throws DatabaseException {
                long time = System.nanoTime();
                SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                Resource subject = ss.getResource(subjectId);
                ArrayList<Entry> entries = DependenciesRelation.this.find(graph, subject);
                long time2 = System.nanoTime();
                LOGGER.info("Found " + entries.size() + " dependencies in " + 1.0E-6 * (double)(time2 - time) + "ms for " + graph.getPossibleURI(subject) + ".");
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                for (Entry entry : entries) {
                    if (entry.name == null) continue;
                    result.add(new Object[]{ss.getRandomAccessId(entry.parent), ss.getRandomAccessId(entry.resource), entry.name, entry.types, entry.id, entry.name, entry.types, entry.typeId});
                }
                return result;
            }
        };
    }

    @Override
    public Pair<String, String>[] getFields() {
        return fields;
    }

    @Override
    public List<Map<String, Object>> query(RequestProcessor session, String search, String bindingPattern, Object[] constants, int maxResultCount) {
        if (!Dependencies.getBindingPattern().equals(bindingPattern)) {
            throw new IllegalArgumentException("DependenciesRelation supports indexing only with 'bfffffff'");
        }
        IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
        return indexer.query(null, search, session, this.resource, (Resource)constants[0], maxResultCount);
    }

    @Override
    public List<Resource> queryResources(RequestProcessor session, String search, String bindingPattern, Object[] constants, int maxResultCount) {
        if (!Dependencies.getBindingPattern().equals(bindingPattern)) {
            throw new IllegalArgumentException("DependenciesRelation supports indexing only with 'bfffffff'");
        }
        IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
        return indexer.queryResources(null, search, session, this.resource, (Resource)constants[0], maxResultCount);
    }

    @Override
    public List<Map<String, Object>> list(RequestProcessor session, String bindingPattern, Object[] constants, int maxResultCount) {
        if (!Dependencies.getBindingPattern().equals(bindingPattern)) {
            throw new IllegalArgumentException("DependenciesRelation supports indexing only with 'bfffffff'");
        }
        IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
        return indexer.query(null, null, session, this.resource, (Resource)constants[0], maxResultCount);
    }

    public static void assertFinishedTracking() {
        if (trackers != 0) {
            throw new IllegalStateException("Trackers should be 0 (was " + trackers + ")");
        }
    }

    @Override
    public synchronized void untrack(RequestProcessor processor, Resource model) {
        if (--trackers < 0) {
            throw new IllegalStateException("Dependency tracking reference count is broken");
        }
        if (trackers == 0) {
            if (listener == null) {
                throw new IllegalStateException("Dependency tracking was not active");
            }
            GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)processor.getService(GraphChangeListenerSupport.class);
            changeSupport.removeMetadataListener(listener);
            listener = null;
        }
    }

    @Override
    public synchronized void trackAndIndex(RequestProcessor processor, Resource model__) {
        if (trackers == 0) {
            if (listener != null) {
                throw new IllegalStateException("Dependency tracking was active");
            }
            listener = new GenericChangeListener<DependencyChangesRequest, DependencyChanges>(){

                public boolean preEventRequest() {
                    return !Indexing.isDependenciesIndexingDisabled();
                }

                public void onEvent(ReadGraph graph, MetadataI metadata, DependencyChanges event) throws DatabaseException {
                    TimeLogger.log(DependenciesRelation.class, (String)"trackAndIndex.onEvent: starting index update processing");
                    WriteGraph w = (WriteGraph)graph;
                    if (!event.isEmpty()) {
                        w.addMetadata((Metadata)event);
                    }
                    Session session = graph.getSession();
                    IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                    for (Map.Entry<Resource, DependencyChanges.Change[]> modelEntry : event.get().entrySet()) {
                        block27: {
                            boolean reset;
                            Resource model = modelEntry.getKey();
                            DependencyChanges.Change[] changes = modelEntry.getValue();
                            boolean linkChange = false;
                            List<Object[]> _additions = Collections.emptyList();
                            List<Object> _removals = Collections.emptyList();
                            List<Object> _replacementKeys = Collections.emptyList();
                            List<Object[]> _replacementObjects = Collections.emptyList();
                            List<Pair<String, String>> _typeChanges = Collections.emptyList();
                            if (changes != null) {
                                _additions = new ArrayList();
                                _removals = new ArrayList();
                                _replacementKeys = new ArrayList();
                                _replacementObjects = new ArrayList();
                                _typeChanges = new HashSet();
                                DependencyChanges.Change[] changeArray = changes;
                                int n = changes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DependencyChanges.Change _entry = changeArray[n2];
                                    if (_entry instanceof DependencyChanges.ComponentAddition) {
                                        Resource parent;
                                        entry = (DependencyChanges.ComponentAddition)_entry;
                                        name = (String)graph.getPossibleRelatedValue(((DependencyChanges.ComponentAddition)entry).component, L0.HasName, (Binding)Bindings.STRING);
                                        typeSet = graph.getTypes(((DependencyChanges.ComponentAddition)entry).component);
                                        if (name != null && typeSet != null && ((DependencyChanges.ComponentAddition)entry).isValid(graph) && (parent = graph.getPossibleObject(((DependencyChanges.ComponentAddition)entry).component, L0.PartOf)) != null) {
                                            id = (GUID)graph.getPossibleRelatedValue(((DependencyChanges.ComponentAddition)entry).component, L0.identifier, GUID.BINDING);
                                            types = (String)graph.syncRequest((Read)new TypeString(L0, typeSet));
                                            typeIds = IndexQueries.toResourceIdString(typeSet);
                                            _additions.add(new Object[]{ss.getRandomAccessId(parent), ss.getRandomAccessId(((DependencyChanges.ComponentAddition)entry).component), name, types, IndexQueries.idFromGUID(id), name, types, typeIds});
                                        }
                                    } else if (_entry instanceof DependencyChanges.ComponentModification) {
                                        entry = (DependencyChanges.ComponentModification)_entry;
                                        name = (String)graph.getPossibleRelatedValue(((DependencyChanges.ComponentModification)entry).component, L0.HasName, (Binding)Bindings.STRING);
                                        if (graph.isInstanceOf(((DependencyChanges.ComponentModification)entry).component, L0.Type)) {
                                            SerialisationSupport support = (SerialisationSupport)session.getService(SerialisationSupport.class);
                                            _typeChanges.add((Pair<String, String>)new Pair((Object)name, (Object)String.valueOf(support.getRandomAccessId(((DependencyChanges.ComponentModification)entry).component))));
                                        } else {
                                            Resource part;
                                            typeSet = graph.getTypes(((DependencyChanges.ComponentModification)entry).component);
                                            if (name != null && !typeSet.isEmpty() && (part = graph.getPossibleObject(((DependencyChanges.ComponentModification)entry).component, L0.PartOf)) != null) {
                                                id = (GUID)graph.getPossibleRelatedValue(((DependencyChanges.ComponentModification)entry).component, L0.identifier, GUID.BINDING);
                                                types = (String)graph.syncRequest((Read)new TypeString(L0, typeSet));
                                                typeIds = IndexQueries.toResourceIdString(typeSet);
                                                _replacementKeys.add(ss.getRandomAccessId(((DependencyChanges.ComponentModification)entry).component));
                                                _replacementObjects.add(new Object[]{ss.getRandomAccessId(part), ss.getRandomAccessId(((DependencyChanges.ComponentModification)entry).component), name, types, IndexQueries.idFromGUID(id), name, types, typeIds});
                                            }
                                        }
                                    } else if (_entry instanceof DependencyChanges.ComponentRemoval) {
                                        entry = (DependencyChanges.ComponentRemoval)_entry;
                                        if (((DependencyChanges.ComponentRemoval)entry).isValid(graph)) {
                                            _removals.add(ss.getRandomAccessId(((DependencyChanges.ComponentRemoval)_entry).component));
                                        }
                                    } else if (_entry instanceof DependencyChanges.LinkChange) {
                                        linkChange = true;
                                    }
                                    ++n2;
                                }
                            }
                            boolean bl = reset = linkChange || event.hasUnresolved;
                            if (!reset && _additions.isEmpty() && _removals.isEmpty() && _replacementKeys.isEmpty() && _typeChanges.isEmpty()) continue;
                            TimeLogger.log(DependenciesRelation.class, (String)"trackAndIndex.onEvent: starting index update");
                            List<Object[]> additions = _additions;
                            List<Object> removals = _removals;
                            List<Object> replacementKeys = _replacementKeys;
                            List<Object[]> replacementObjects = _replacementObjects;
                            boolean typeNameChanges = DependenciesRelation.this.typeNameChanges(graph, indexer, model, _typeChanges);
                            UUID pending = Indexing.makeIndexPending();
                            try {
                                try {
                                    boolean didChange = false;
                                    boolean doReset = typeNameChanges;
                                    if (doReset) {
                                        indexer.removeAll(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model);
                                        didChange = true;
                                    } else {
                                        if (!replacementKeys.isEmpty() && replacementKeys.size() == replacementObjects.size()) {
                                            didChange |= indexer.replace(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model, "Resource", replacementKeys, replacementObjects);
                                        }
                                        if (!removals.isEmpty()) {
                                            indexer.remove(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model, "Resource", removals);
                                            didChange = true;
                                        }
                                        if (!additions.isEmpty()) {
                                            indexer.insert(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model, additions);
                                            didChange = true;
                                        }
                                    }
                                    if (didChange) {
                                        DependenciesRelation.this.fireListeners((RequestProcessor)graph, model);
                                    }
                                }
                                catch (Throwable t) {
                                    LOGGER.error("Dependencies index update failed for model " + String.valueOf(model) + " and relation " + String.valueOf(DependenciesRelation.this.resource) + ".", t);
                                    Indexing.releaseIndexPending((UUID)pending);
                                    Indexing.clearCaches((Resource)model);
                                    break block27;
                                }
                            }
                            catch (Throwable throwable) {
                                Indexing.releaseIndexPending((UUID)pending);
                                Indexing.clearCaches((Resource)model);
                                throw throwable;
                            }
                            Indexing.releaseIndexPending((UUID)pending);
                            Indexing.clearCaches((Resource)model);
                        }
                        TimeLogger.log(DependenciesRelation.class, (String)"trackAndIndex.onEvent: index update done");
                    }
                }
            };
            GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)processor.getService(GraphChangeListenerSupport.class);
            changeSupport.addMetadataListener(listener);
        }
        ++trackers;
    }

    private boolean typeNameChanges(ReadGraph graph, IndexedRelations indexer, Resource model, Collection<Pair<String, String>> typeChanges) throws DatabaseException {
        if (typeChanges.isEmpty()) {
            return false;
        }
        for (Pair<String, String> nr : typeChanges) {
            String query = "Resource:[" + (String)nr.second + " TO " + (String)nr.second + "]";
            List<Map<String, Object>> results = indexer.query(null, query, (RequestProcessor)graph, this.resource, model, Integer.MAX_VALUE);
            if (results.size() != 1) {
                return true;
            }
            Map<String, Object> result = results.get(0);
            if (ObjectUtils.objectEquals((Object)result.get("Name"), (Object)nr.first)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(RequestProcessor processor, Resource model, Runnable observer) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().getService(DependenciesListenerStore.class);
        store.addListener(model, observer);
    }

    @Override
    public void removeListener(RequestProcessor processor, Resource model, Runnable observer) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().getService(DependenciesListenerStore.class);
        store.removeListener(model, observer);
    }

    void fireListeners(RequestProcessor processor, Resource model) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().peekService(DependenciesListenerStore.class);
        if (store != null) {
            store.fireListeners(model);
        }
    }

    @Override
    public void reset(RequestProcessor processor, Resource input) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().getService(DependenciesListenerStore.class);
        store.fireListeners(input);
    }

    public static void addSubtree(ReadGraph graph, Resource root) throws DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new IndexRoot(root));
        DependenciesRelation.addSubtree(graph, indexRoot, root);
    }

    public static void addSubtree(ReadGraph graph, Resource indexRoot, Resource subtreeRoot) throws DatabaseException {
        DependenciesRelation dr = new DependenciesRelation(graph, indexRoot);
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        ArrayList<Entry> entries = dr.find(graph, subtreeRoot);
        entries.add(new Entry(graph, subtreeRoot));
        ArrayList<Object[]> result = new ArrayList<Object[]>(entries.size());
        for (Entry entry : entries) {
            result.add(new Object[]{ss.getRandomAccessId(entry.parent), ss.getRandomAccessId(entry.resource), entry.name, entry.types, entry.id, entry.name, entry.types, entry.typeId});
        }
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        IndexedRelations indexer = (IndexedRelations)graph.getService(IndexedRelations.class);
        indexer.insert(null, (RequestProcessor)graph, dr, L0X.DependenciesRelation, indexRoot, result);
    }

    public static class DependencyChangesRequest
    extends UnaryRead<ChangeSet, DependencyChanges> {
        private static final boolean LOG = false;

        public DependencyChangesRequest(ChangeSet parameter) {
            super((Object)parameter);
        }

        public DependencyChanges perform(ReadGraph graph) throws DatabaseException {
            DependencyChangesWriter w = new DependencyChangesWriter(graph);
            Layer0 l0 = w.l0;
            Resource changeInformation = graph.getPossibleResource("http://www.simantics.org/Modeling-1.2/changeInformation/Inverse");
            for (Resource value : ((ChangeSet)this.parameter).changedValues()) {
                Statement modifiedComponent;
                if (!value.isPersistent() || (modifiedComponent = graph.getPossibleStatement(value, l0.PropertyOf)) == null || modifiedComponent.getPredicate().equals(changeInformation)) continue;
                w.addComponentModification(modifiedComponent.getObject());
            }
            for (Resource value : ((ChangeSet)this.parameter).changedResources()) {
                if (graph.isImmutable(value)) continue;
                w.addComponentModification(value);
            }
            for (ChangeSet.StatementChange change : ((ChangeSet)this.parameter).changedStatements()) {
                Resource subject = change.getSubject();
                Resource predicate = change.getPredicate();
                Resource object = change.getObject();
                if (!object.isPersistent()) continue;
                if (predicate.equals(l0.ConsistsOf)) {
                    if (change.isClaim()) {
                        w.addComponentAddition(subject, object);
                        continue;
                    }
                    w.addComponentRemoval(subject, object);
                    continue;
                }
                if (predicate.equals(l0.IsLinkedTo)) {
                    w.addLinkChange(subject);
                    continue;
                }
                if (!graph.isSubrelationOf(predicate, l0.IsNoticeablyRelatedTo)) continue;
                w.addComponentModification(subject);
            }
            return w.getResult();
        }
    }

    class Process {
        final ArrayList<Entry> result = new ArrayList();
        final SyncContextMultiProcedure<Resource, Resource> structure;
        final SyncContextProcedure<Entry, String> names;
        final SyncContextProcedure<Entry, byte[]> guid;
        final SyncContextProcedure<Entry, Resource> type;

        Process(ReadGraph graph, final Resource resource) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            this.names = dqs.compilePossibleRelatedValue(graph, L0.HasName, (SyncContextProcedure)new SyncContextProcedure<Entry, String>(){

                public void execute(ReadGraph graph, Entry entry, String name) {
                    entry.name = name;
                }

                public void exception(ReadGraph graph, Throwable throwable) {
                    LOGGER.error("Could not compile possible related value for resource {}", (Object)resource, (Object)throwable);
                }
            });
            this.guid = dqs.compilePossibleRelatedValue(graph, L0.identifier, (SyncContextProcedure)new SyncContextProcedure<Entry, byte[]>(){

                public void execute(ReadGraph graph, Entry entry, byte[] guidBytes) {
                    entry.guid = guidBytes;
                }

                public void exception(ReadGraph graph, Throwable throwable) {
                    LOGGER.error("Could not compile possible related value for resource {}", (Object)resource, (Object)throwable);
                }
            });
            this.type = new SyncContextProcedure<Entry, Resource>(){

                public void execute(ReadGraph graph, Entry entry, Resource type) {
                    entry.principalType = type;
                }

                public void exception(ReadGraph graph, Throwable throwable) {
                    LOGGER.error("Could not find type for resource {}", (Object)resource, (Object)throwable);
                }
            };
            this.structure = dqs.compileForEachObject(graph, L0.ConsistsOf, (SyncContextMultiProcedure)new SyncContextMultiProcedure<Resource, Resource>(){

                public void execute(ReadGraph graph, Resource parent, Resource child) {
                    if (!child.isPersistent()) {
                        return;
                    }
                    Entry entry = new Entry(parent, child, "", "", "");
                    Process.this.result.add(entry);
                    dqs.forEachObjectCompiled(graph, child, (Object)child, Process.this.structure);
                    dqs.forPossibleRelatedValueCompiled(graph, child, (Object)entry, Process.this.names);
                    dqs.forPossibleRelatedValueBytesCompiled(graph, child, (Object)entry, Process.this.guid);
                    dqs.forPossibleDirectType(graph, child, (Object)entry, Process.this.type);
                }

                public void finished(ReadGraph graph, Resource parent) {
                }

                public void exception(ReadGraph graph, Throwable throwable) {
                    if (throwable instanceof NoSingleResultException) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Could not compile for resource {}", (Object)resource, (Object)throwable);
                        }
                    } else {
                        LOGGER.error("Could not compile for resource {}", (Object)resource, (Object)throwable);
                    }
                }
            });
            this.result.add(new Entry(graph, resource));
            graph.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    dqs.forEachObjectCompiled(graph, resource, (Object)resource, Process.this.structure);
                }
            });
            Map typeStrings = (Map)cs.createMap(String.class);
            for (final Entry e : this.result) {
                if (e.principalType != null) {
                    Pair typeString = (Pair)typeStrings.get(e.principalType);
                    if (typeString == null) {
                        String superTypeString = (String)graph.syncRequest((Read)new SuperTypeString(e.principalType));
                        if (superTypeString.isEmpty()) {
                            LOGGER.error("No name for type", (Throwable)new DatabaseException("No name for type " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)e.resource) + " (" + String.valueOf(e.resource) + ")"));
                        }
                        String superTypeIds = IndexQueries.toResourceIdString(e.principalType, graph.getSupertypes(e.principalType));
                        typeString = Pair.make((Object)superTypeString, (Object)superTypeIds);
                        typeStrings.put(e.principalType, typeString);
                    }
                    e.types = (String)typeString.first;
                    e.typeId = (String)typeString.second;
                } else {
                    Set typeSet = (Set)graph.syncRequest((Read)new UniqueRead<Set<Resource>>(){

                        public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
                            return graph.getTypes(e.resource);
                        }
                    }, (Listener)TransientCacheListener.instance());
                    e.types = (String)graph.syncRequest((Read)new TypeString(L0, typeSet), (Listener)TransientCacheListener.instance());
                    e.typeId = IndexQueries.toResourceIdString(typeSet);
                }
                e.id = GUID.possibleIndexString((byte[])e.guid, (int)0, (String)"");
            }
        }
    }
}

