/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import gnu.trove.set.hash.THashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.db.Resource;

class DependenciesListenerStore {
    private final Map<Resource, Set<Runnable>> listeners = new HashMap<Resource, Set<Runnable>>();

    DependenciesListenerStore() {
    }

    public synchronized void addListener(Resource model, Runnable listener) {
        THashSet list = this.listeners.get(model);
        if (list == null) {
            list = new THashSet();
            this.listeners.put(model, (Set<Runnable>)list);
        }
        list.add((Runnable)listener);
    }

    public synchronized void removeListener(Resource model, Runnable listener) {
        Set<Runnable> list = this.listeners.get(model);
        if (list == null) {
            return;
        }
        list.remove(listener);
    }

    public synchronized void fireListeners(Resource model) {
        Set<Runnable> list = this.listeners.get(model);
        if (list == null) {
            return;
        }
        for (Runnable r : list) {
            r.run();
        }
    }
}

