/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.FreshEscapedName;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.AbstractImportAdvisor2;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;

public class DefaultPasteImportAdvisor
extends AbstractImportAdvisor2 {
    protected Resource library;
    protected Resource temp;
    protected Resource model;
    protected String singleType = null;
    protected long[] ids;
    protected Map<String, String> nameMappings = new HashMap<String, String>();
    protected final Map<String, Object> context;

    public DefaultPasteImportAdvisor(ReadGraph graph, Resource library) throws DatabaseException {
        this(library, (Resource)graph.syncRequest((Read)new PossibleIndexRoot(library)), Collections.emptyMap());
    }

    public DefaultPasteImportAdvisor(Resource library) {
        this(library, library, Collections.emptyMap());
    }

    public DefaultPasteImportAdvisor(Resource library, Map<String, Object> context) {
        this(library, library, context);
    }

    public DefaultPasteImportAdvisor(Resource library, Resource model, Map<String, Object> context) {
        this.library = library;
        this.model = model;
        this.context = context;
    }

    public void redirect(Resource temp) {
        this.temp = temp;
    }

    protected Resource getRedirectTarget() {
        if (this.temp != null) {
            return this.temp;
        }
        return this.library;
    }

    public Resource getTarget() {
        return this.library;
    }

    public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
    }

    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
        if ("%model".equals(root.name)) {
            return this.model;
        }
        this.analyzeType(graph, root);
        String type = root.type;
        if (this.singleType != null) {
            if (!type.equals(this.singleType)) {
                throw new DatabaseException("Paste of a set of different types of objects is not supported.");
            }
        } else {
            this.singleType = type;
        }
        if (this.library != null) {
            String newName = this.newName(graph, this.library, root.name);
            this.nameMappings.put(root.name, newName);
        }
        return null;
    }

    public String newName(ReadGraph graph, Resource library, String name) throws DatabaseException {
        String renamed;
        Map renameMap = (Map)this.context.get("renameMap");
        if (renameMap != null && (renamed = (String)renameMap.get(name)) != null) {
            return renamed;
        }
        String version = Versions.getVersion((String)name);
        if (version != null) {
            String baseName = Versions.getBaseName((String)name);
            String newBaseName = (String)graph.syncRequest((Read)new FreshEscapedName(library, Layer0.getInstance((ReadGraph)graph).ConsistsOf, baseName));
            return Versions.make((String)newBaseName, (String)Versions.getBaseVersion((String)version));
        }
        return (String)graph.syncRequest((Read)new FreshEscapedName(library, Layer0.getInstance((ReadGraph)graph).ConsistsOf, name));
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        return this.createRoot(graph, root, null);
    }

    public String getName(Root root) {
        String name = root.name;
        String newName = this.nameMappings.get(name);
        if (newName != null) {
            name = newName;
        }
        return name;
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
        Layer0 l0 = (Layer0)graph.getService(Layer0.class);
        if (resource == null) {
            resource = graph.newResource();
        }
        if (this.getRedirectTarget() != null) {
            graph.claim(this.getRedirectTarget(), l0.ConsistsOf, l0.PartOf, resource);
        }
        String newName = this.getName(root);
        graph.addLiteral(resource, l0.HasName, l0.NameOf, l0.String, (Object)newName, (Binding)Bindings.STRING);
        this.addRootInfo(root, newName, resource);
        return resource;
    }

    public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
    }

    public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        this.ids = process.getResourceIds((SerialisationSupport)graph.getService(SerialisationSupport.class));
    }

    public boolean allowImmutableModifications() {
        return false;
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, String name) throws DatabaseException {
        return process.createChild(graph, parent, null, name);
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child, String name) throws DatabaseException {
        return process.createChild(graph, parent, child, name);
    }

    public long[] getResourceIds() {
        return this.ids;
    }
}

