/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SCLVariableMap
implements VariableMap {
    private VariableMap basis;
    private Function1<Variable, List<Variable>> getVariablesF;

    public SCLVariableMap(VariableMap basis, Function1<Variable, List<Variable>> getVariablesF) {
        this.basis = basis;
        this.getVariablesF = getVariablesF;
    }

    public SCLVariableMap(Function1<Variable, List<Variable>> getVariablesF) {
        this(null, getVariablesF);
    }

    private Collection<Variable> apply(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            sclContext.put((Object)"graph", (Object)graph);
            if (this.basis != null) {
                TreeMap<String, Variable> result = new TreeMap<String, Variable>();
                this.basis.getVariables(graph, context, result);
                for (Variable scl : (List)this.getVariablesF.apply((Object)context)) {
                    result.put(scl.getName(graph), scl);
                }
                Collection<Variable> collection = result.values();
                return collection;
            }
            Collection collection = (Collection)this.getVariablesF.apply((Object)context);
            return collection;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    @Override
    public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
        for (Variable variable : this.apply(graph, context)) {
            if (!variable.getName(graph).equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        for (Variable variable : this.apply(graph, context)) {
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            map.put(variable.getName(graph), variable);
        }
        return map;
    }

    @Override
    public Map<String, Variable> getVariables(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
        for (Variable variable : this.apply(graph, context)) {
            if (!variable.getClassifications(graph).contains(classification)) continue;
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            map.put(variable.getName(graph), variable);
        }
        return map;
    }
}

