/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.single.SingleSetSyncListener;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableFactoryRequest;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableFactory;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;
import org.simantics.operation.Layer0X;

public class ExtendedGraphChildVariable
extends StandardGraphChildVariable {
    private Map<String, Variable> extension;
    private List<Listener<Map<String, Variable>>> listeners = new ArrayList<Listener<Map<String, Variable>>>();

    public ExtendedGraphChildVariable(Variable parent, Resource resource) throws DatabaseException {
        super(parent, null, resource);
    }

    Map<String, Variable> getExtension(ReadGraph graph) throws DatabaseException {
        if (this.extension == null) {
            this.extension = new HashMap<String, Variable>();
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            qc.getIndependentGraph(graph).syncRequest((Read)new ResourceRead<Collection<VariableFactory>>(this.resource){

                public Collection<VariableFactory> perform(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    ArrayList<VariableFactory> result = new ArrayList<VariableFactory>();
                    for (Resource r : graph.getObjects(this.resource, L0X.HasChildVariables)) {
                        VariableFactory factory = (VariableFactory)graph.adapt(r, VariableFactory.class);
                        if (!$assertionsDisabled && factory == null) {
                            throw new AssertionError();
                        }
                        result.add(factory);
                    }
                    return result;
                }
            }, (AsyncProcedure)new SingleSetSyncListener<VariableFactory>(){

                public void add(ReadGraph graph, VariableFactory factory) throws DatabaseException {
                    graph.syncRequest((Read)new VariableFactoryRequest(ExtendedGraphChildVariable.this, factory), (AsyncProcedure)new SingleSetSyncListener<Variable>(){

                        public void add(ReadGraph graph, Variable child) throws DatabaseException {
                            String name = (String)child.getPropertyValue(graph, "HasName");
                            (this).ExtendedGraphChildVariable.this.extension.put(name, child);
                        }

                        public void remove(ReadGraph graph, Variable child) throws DatabaseException {
                            String name = (String)child.getPropertyValue(graph, "HasName");
                            Variable exist = (this).ExtendedGraphChildVariable.this.extension.get(name);
                            if (exist == child) {
                                (this).ExtendedGraphChildVariable.this.extension.remove(name);
                            }
                        }

                        public void finished(ReadGraph graph) throws DatabaseException {
                            Map<String, Variable> clone = ExtendedGraphChildVariable.this.getClone();
                            for (Listener<Map<String, Variable>> listener : (this).ExtendedGraphChildVariable.this.listeners) {
                                listener.execute(clone);
                            }
                        }

                        public boolean isDisposed() {
                            return false;
                        }
                    });
                }

                public boolean isDisposed() {
                    return false;
                }
            });
        }
        return (Map)graph.syncRequest((ExternalRead)new ParametrizedPrimitiveRead<Variable, Map<String, Variable>>((Variable)this){

            public void register(ReadGraph graph, Listener<Map<String, Variable>> procedure) {
                ExtendedGraphChildVariable.this.listeners.add(procedure);
                procedure.execute(ExtendedGraphChildVariable.this.getClone());
            }
        });
    }

    private Map<String, Variable> getClone() {
        HashMap<String, Variable> clone = new HashMap<String, Variable>();
        clone.putAll(this.extension);
        return clone;
    }

    @Override
    public Variable getPossibleSpecialChild(ReadGraph graph, String name) throws DatabaseException {
        return this.getExtension(graph).get(name);
    }

    public void collectSpecialChildren(ReadGraph graph, Collection<Variable> children) throws DatabaseException {
        children.addAll(this.getExtension(graph).values());
    }
}

