/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IsParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;

public class TGConfigurer2 {
    final Collection<TransferableGraphConfiguration2.SeedSpec> seeds = new ArrayList<TransferableGraphConfiguration2.SeedSpec>();
    final Map<Resource, SubgraphExtent.ExtentStatus> preStatus = new HashMap<Resource, SubgraphExtent.ExtentStatus>();
    final boolean ignoreVirtualResources;
    final boolean validate;

    public TGConfigurer2(boolean ignoreVirtualResources, boolean validate) {
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.validate = validate;
    }

    public TGConfigurer2 addInternalSeed(ReadGraph graph, Resource r) throws DatabaseException {
        for (TransferableGraphConfiguration2.SeedSpec spec : this.seeds) {
            if (!TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL.equals((Object)spec.specType) || !((Boolean)graph.syncRequest((Read)new IsParent(spec.resource, r))).booleanValue()) continue;
            return this;
        }
        ArrayList<Resource> removals = new ArrayList<Resource>();
        for (TransferableGraphConfiguration2.SeedSpec spec : this.seeds) {
            if (!TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL.equals((Object)spec.specType) || !((Boolean)graph.syncRequest((Read)new IsParent(r, spec.resource))).booleanValue()) continue;
            removals.add(spec.resource);
        }
        for (Resource removal : removals) {
            TransferableGraphConfiguration2.SeedSpec spec = this.getSeed(removal);
            if (spec == null) continue;
            this.seeds.remove(spec);
        }
        this.seeds.add(new TransferableGraphConfiguration2.SeedSpec(r, "", TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL));
        return this;
    }

    private TransferableGraphConfiguration2.SeedSpec getSeed(Resource r) {
        for (TransferableGraphConfiguration2.SeedSpec spec : this.seeds) {
            if (!spec.resource.equals(r)) continue;
            return spec;
        }
        return null;
    }

    public TGConfigurer2 addExternal(Resource r) throws DatabaseException {
        this.preStatus.put(r, SubgraphExtent.ExtentStatus.EXTERNAL);
        return this;
    }

    public TGConfigurer2 addExcluded(Resource r) throws DatabaseException {
        this.preStatus.put(r, SubgraphExtent.ExtentStatus.EXCLUDED);
        return this;
    }

    public TransferableGraphConfiguration2 create() throws DatabaseException {
        return new TransferableGraphConfiguration2(null, this.seeds, this.preStatus, this.ignoreVirtualResources, this.validate);
    }
}

